/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request;

import com.slack.api.app_backend.SlackSignature;
import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.context.builtin.OAuthCallbackContext;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public abstract class Request<CTX extends Context> {
    private String clientIpAddress;

    public String getClientIpAddress() {
        return this.clientIpAddress;
    }

    public void setClientIpAddress(String clientIpAddress) {
        this.clientIpAddress = clientIpAddress;
    }

    public abstract CTX getContext();

    public void updateContext(AppConfig config) {
        ((Context)this.getContext()).setSlack(config.getSlack());
        if (!config.isDistributedApp() && ((Context)this.getContext()).getBotToken() == null && config.getSingleTeamBotToken() != null) {
            ((Context)this.getContext()).setBotToken(config.getSingleTeamBotToken());
        }
        if (config.isOAuthCallbackEnabled() && this.getContext() instanceof OAuthCallbackContext) {
            OAuthCallbackContext ctx = (OAuthCallbackContext)this.getContext();
            ctx.setOauthCompletionUrl(config.getOauthCompletionUrl());
            ctx.setOauthCancellationUrl(config.getOauthCancellationUrl());
        }
    }

    public abstract RequestType getRequestType();

    public Map<String, List<String>> getQueryString() {
        return Collections.emptyMap();
    }

    public abstract String getRequestBodyAsString();

    public abstract RequestHeaders getHeaders();

    public boolean isValid(SlackSignature.Verifier verifier) {
        return this.isValid(verifier, System.currentTimeMillis());
    }

    public boolean isValid(SlackSignature.Verifier verifier, long nowInMillis) {
        String requestTimestamp = this.getHeaders().getFirstValue("X-Slack-Request-Timestamp");
        String requestSignature = this.getHeaders().getFirstValue("X-Slack-Signature");
        return verifier.isValid(requestTimestamp, this.getRequestBodyAsString(), requestSignature, nowInMillis);
    }

    @Generated
    public String toString() {
        return "Request(clientIpAddress=" + this.getClientIpAddress() + ")";
    }
}

