/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.service.builtin.oauth.default_impl;

import com.slack.api.bolt.context.builtin.OAuthCallbackContext;
import com.slack.api.bolt.model.builtin.DefaultInstaller;
import com.slack.api.bolt.request.builtin.OAuthCallbackRequest;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.service.InstallationService;
import com.slack.api.bolt.service.builtin.oauth.OAuthV2SuccessHandler;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.response.auth.AuthTestResponse;
import com.slack.api.methods.response.oauth.OAuthV2AccessResponse;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthV2DefaultSuccessHandler
implements OAuthV2SuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(OAuthV2DefaultSuccessHandler.class);
    private InstallationService installationService;

    public OAuthV2DefaultSuccessHandler(InstallationService installationService) {
        this.installationService = installationService;
    }

    @Override
    public Response handle(OAuthCallbackRequest request, Response response, OAuthV2AccessResponse o) {
        OAuthCallbackContext context = request.getContext();
        if (o.getEnterprise() != null) {
            context.setEnterpriseId(o.getEnterprise().getId());
        }
        context.setTeamId(o.getTeam().getId());
        context.setBotUserId(o.getBotUserId());
        context.setBotToken(o.getAccessToken());
        context.setRequestUserId(o.getAuthedUser().getId());
        context.setRequestUserToken(o.getAccessToken());
        DefaultInstaller.DefaultInstallerBuilder i = DefaultInstaller.builder().botUserId(o.getBotUserId()).botAccessToken(o.getAccessToken()).enterpriseId(o.getEnterprise() != null ? o.getEnterprise().getId() : null).teamId(o.getTeam().getId()).teamName(o.getTeam().getName()).scope(o.getScope()).botScope(o.getScope()).installedAt(System.currentTimeMillis());
        if (o.getAuthedUser() != null) {
            i = i.installerUserId(o.getAuthedUser().getId()).installerUserAccessToken(o.getAuthedUser().getAccessToken()).installerUserScope(o.getAuthedUser().getScope());
        }
        if (o.getBotUserId() != null) {
            try {
                AuthTestResponse authTest = context.client().authTest(r -> r);
                if (authTest.isOk()) {
                    i = i.botId(authTest.getBotId());
                } else {
                    log.warn("Failed to call auth.test to fetch botId for the user: {} - {}", (Object)o.getBotUserId(), (Object)authTest.getError());
                }
            }
            catch (SlackApiException | IOException e) {
                log.warn("Failed to call auth.test to fetch botId for the user: {}", (Object)o.getBotUserId(), (Object)e);
            }
        }
        if (o.getIncomingWebhook() != null) {
            i = i.incomingWebhookChannelId(o.getIncomingWebhook().getChannelId()).incomingWebhookUrl(o.getIncomingWebhook().getUrl()).incomingWebhookConfigurationUrl(o.getIncomingWebhook().getConfigurationUrl());
        }
        DefaultInstaller installer = i.build();
        response.setStatusCode(302);
        try {
            this.installationService.saveInstallerAndBot(installer);
            response.getHeaders().put("Location", Arrays.asList(context.getOauthCompletionUrl()));
        }
        catch (Exception e) {
            log.warn("Failed to store the installation - {}", (Object)e.getMessage(), (Object)e);
            response.getHeaders().put("Location", Arrays.asList(context.getOauthCancellationUrl()));
        }
        return response;
    }
}

