/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.slack.api.app_backend.outgoing_webhooks.WebhookPayloadParser;
import com.slack.api.app_backend.outgoing_webhooks.payload.WebhookPayload;
import com.slack.api.bolt.context.builtin.OutgoingWebhooksContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;

public class OutgoingWebhooksRequest
extends Request<OutgoingWebhooksContext> {
    private static final WebhookPayloadParser PAYLOAD_PARSER = new WebhookPayloadParser();
    private final String requestBody;
    private final RequestHeaders headers;
    private final WebhookPayload payload;
    private OutgoingWebhooksContext context = new OutgoingWebhooksContext();

    public OutgoingWebhooksRequest(String requestBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        this.payload = PAYLOAD_PARSER.parse(requestBody);
        this.getContext().setTeamId(this.payload.getTeamId());
        this.getContext().setChannelId(this.payload.getChannelId());
        this.getContext().setRequestUserId(this.payload.getUserId());
    }

    @Override
    public OutgoingWebhooksContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.OutgoingWebhooks;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public WebhookPayload getPayload() {
        return this.payload;
    }

    @Override
    public String toString() {
        return "OutgoingWebhooksRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ", context=" + this.getContext() + ")";
    }
}

