/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.context.builtin;

import com.slack.api.app_backend.views.response.ViewSubmissionResponse;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.util.BuilderConfigurator;
import com.slack.api.model.view.View;
import java.util.Map;

public class ViewSubmissionContext
extends Context {
    public Response ack(ViewSubmissionResponse response) {
        return Response.json(200, response);
    }

    public Response ack(BuilderConfigurator<ViewSubmissionResponse.ViewSubmissionResponseBuilder> builder) {
        return this.ack(builder.configure(ViewSubmissionResponse.builder()).build());
    }

    public Response ackWithErrors(Map<String, String> errors) {
        ViewSubmissionResponse response = ViewSubmissionResponse.builder().responseAction("errors").errors(errors).build();
        return this.ack(response);
    }

    public Response ackWithUpdate(View view) {
        return this.ack("update", view);
    }

    public Response ackWithUpdate(String view) {
        return this.ack("update", view);
    }

    public Response ackWithPush(View view) {
        return this.ack("push", view);
    }

    public Response ackWithPush(String view) {
        return this.ack("push", view);
    }

    public Response ack(String responseAction, View view) {
        ViewSubmissionResponse response = ViewSubmissionResponse.builder().responseAction(responseAction).view(view).build();
        return this.ack(response);
    }

    public Response ack(String responseAction, String view) {
        ViewSubmissionResponse response = ViewSubmissionResponse.builder().responseAction(responseAction).viewAsString(view).build();
        return this.ack(response);
    }

    public static ViewSubmissionContextBuilder builder() {
        return new ViewSubmissionContextBuilder();
    }

    @Override
    public String toString() {
        return "ViewSubmissionContext(super=" + super.toString() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewSubmissionContext)) {
            return false;
        }
        ViewSubmissionContext other = (ViewSubmissionContext)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ViewSubmissionContext;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public static class ViewSubmissionContextBuilder {
        ViewSubmissionContextBuilder() {
        }

        public ViewSubmissionContext build() {
            return new ViewSubmissionContext();
        }

        public String toString() {
            return "ViewSubmissionContext.ViewSubmissionContextBuilder()";
        }
    }
}

