/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.context.builtin;

import com.slack.api.app_backend.interactive_components.response.ActionResponse;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.context.SayUtility;
import com.slack.api.bolt.response.ResponseUrlSender;
import com.slack.api.bolt.util.BuilderConfigurator;
import com.slack.api.model.block.LayoutBlock;
import com.slack.api.webhook.WebhookResponse;
import java.io.IOException;
import java.util.List;

public class DialogCancellationContext
extends Context
implements SayUtility {
    private String responseUrl;
    private String channelId;
    private ResponseUrlSender responseUrlSender;

    public WebhookResponse respond(String text) throws IOException {
        return this.respond(ActionResponse.builder().text(text).build());
    }

    public WebhookResponse respond(List<LayoutBlock> blocks) throws IOException {
        return this.respond(ActionResponse.builder().blocks(blocks).build());
    }

    public WebhookResponse respond(ActionResponse response) throws IOException {
        if (this.responseUrlSender == null) {
            this.responseUrlSender = new ResponseUrlSender(this.slack, this.responseUrl);
        }
        return new ResponseUrlSender(this.slack, this.responseUrl).send(response);
    }

    public WebhookResponse respond(BuilderConfigurator<ActionResponse.ActionResponseBuilder> builder) throws IOException {
        return this.respond(builder.configure(ActionResponse.builder()).build());
    }

    public static DialogCancellationContextBuilder builder() {
        return new DialogCancellationContextBuilder();
    }

    public String getResponseUrl() {
        return this.responseUrl;
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    public ResponseUrlSender getResponseUrlSender() {
        return this.responseUrlSender;
    }

    public void setResponseUrl(String responseUrl) {
        this.responseUrl = responseUrl;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setResponseUrlSender(ResponseUrlSender responseUrlSender) {
        this.responseUrlSender = responseUrlSender;
    }

    public DialogCancellationContext() {
    }

    public DialogCancellationContext(String responseUrl, String channelId, ResponseUrlSender responseUrlSender) {
        this.responseUrl = responseUrl;
        this.channelId = channelId;
        this.responseUrlSender = responseUrlSender;
    }

    @Override
    public String toString() {
        return "DialogCancellationContext(super=" + super.toString() + ", responseUrl=" + this.getResponseUrl() + ", channelId=" + this.getChannelId() + ", responseUrlSender=" + this.getResponseUrlSender() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DialogCancellationContext)) {
            return false;
        }
        DialogCancellationContext other = (DialogCancellationContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$responseUrl = this.getResponseUrl();
        String other$responseUrl = other.getResponseUrl();
        if (this$responseUrl == null ? other$responseUrl != null : !this$responseUrl.equals(other$responseUrl)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
            return false;
        }
        ResponseUrlSender this$responseUrlSender = this.getResponseUrlSender();
        ResponseUrlSender other$responseUrlSender = other.getResponseUrlSender();
        return !(this$responseUrlSender == null ? other$responseUrlSender != null : !this$responseUrlSender.equals(other$responseUrlSender));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DialogCancellationContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $responseUrl = this.getResponseUrl();
        result = result * 59 + ($responseUrl == null ? 43 : $responseUrl.hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        ResponseUrlSender $responseUrlSender = this.getResponseUrlSender();
        result = result * 59 + ($responseUrlSender == null ? 43 : $responseUrlSender.hashCode());
        return result;
    }

    public static class DialogCancellationContextBuilder {
        private String responseUrl;
        private String channelId;
        private ResponseUrlSender responseUrlSender;

        DialogCancellationContextBuilder() {
        }

        public DialogCancellationContextBuilder responseUrl(String responseUrl) {
            this.responseUrl = responseUrl;
            return this;
        }

        public DialogCancellationContextBuilder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public DialogCancellationContextBuilder responseUrlSender(ResponseUrlSender responseUrlSender) {
            this.responseUrlSender = responseUrlSender;
            return this;
        }

        public DialogCancellationContext build() {
            return new DialogCancellationContext(this.responseUrl, this.channelId, this.responseUrlSender);
        }

        public String toString() {
            return "DialogCancellationContext.DialogCancellationContextBuilder(responseUrl=" + this.responseUrl + ", channelId=" + this.channelId + ", responseUrlSender=" + this.responseUrlSender + ")";
        }
    }
}

