/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.slack.api.app_backend.oauth.payload.VerificationCodePayload;
import com.slack.api.app_backend.outgoing_webhooks.WebhookPayloadDetector;
import com.slack.api.app_backend.slash_commands.SlashCommandPayloadDetector;
import com.slack.api.app_backend.ssl_check.SSLCheckPayloadDetector;
import com.slack.api.app_backend.util.JsonPayloadExtractor;
import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.builtin.AttachmentActionRequest;
import com.slack.api.bolt.request.builtin.BlockActionRequest;
import com.slack.api.bolt.request.builtin.BlockSuggestionRequest;
import com.slack.api.bolt.request.builtin.DialogCancellationRequest;
import com.slack.api.bolt.request.builtin.DialogSubmissionRequest;
import com.slack.api.bolt.request.builtin.DialogSuggestionRequest;
import com.slack.api.bolt.request.builtin.EventRequest;
import com.slack.api.bolt.request.builtin.MessageActionRequest;
import com.slack.api.bolt.request.builtin.OAuthCallbackRequest;
import com.slack.api.bolt.request.builtin.OAuthStartRequest;
import com.slack.api.bolt.request.builtin.OutgoingWebhooksRequest;
import com.slack.api.bolt.request.builtin.SSLCheckRequest;
import com.slack.api.bolt.request.builtin.SlashCommandRequest;
import com.slack.api.bolt.request.builtin.UrlVerificationRequest;
import com.slack.api.bolt.request.builtin.ViewClosedRequest;
import com.slack.api.bolt.request.builtin.ViewSubmissionRequest;
import com.slack.api.util.json.GsonFactory;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackRequestParser {
    private static final Logger log = LoggerFactory.getLogger(SlackRequestParser.class);
    private final AppConfig appConfig;
    private JsonPayloadExtractor jsonPayloadExtractor = new JsonPayloadExtractor();
    private SlashCommandPayloadDetector commandRequestDetector = new SlashCommandPayloadDetector();
    private SSLCheckPayloadDetector sslCheckPayloadDetector = new SSLCheckPayloadDetector();
    private WebhookPayloadDetector webhookRequestDetector = new WebhookPayloadDetector();
    private Gson gson = GsonFactory.createSnakeCase();

    public SlackRequestParser(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Request<?> parse(HttpRequest httpRequest) {
        String requestUri = httpRequest.getRequestUri();
        String requestBody = httpRequest.getRequestBody();
        RequestHeaders headers = httpRequest.getHeaders();
        Request slackRequest = null;
        try {
            String jsonPayload = this.jsonPayloadExtractor.extractIfExists(requestBody);
            if (jsonPayload != null) {
                String payloadType;
                JsonObject payload = ((JsonElement)this.gson.fromJson(jsonPayload, JsonElement.class)).getAsJsonObject();
                switch (payloadType = payload.get("type").getAsString()) {
                    case "interactive_message": {
                        slackRequest = new AttachmentActionRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    case "block_actions": {
                        slackRequest = new BlockActionRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    case "block_suggestion": {
                        slackRequest = new BlockSuggestionRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    case "message_action": {
                        slackRequest = new MessageActionRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    case "event_callback": {
                        slackRequest = new EventRequest(jsonPayload, headers);
                        break;
                    }
                    case "url_verification": {
                        slackRequest = new UrlVerificationRequest(jsonPayload, headers);
                        break;
                    }
                    case "dialog_cancellation": {
                        slackRequest = new DialogCancellationRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    case "dialog_submission": {
                        slackRequest = new DialogSubmissionRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    case "dialog_suggestion": {
                        slackRequest = new DialogSuggestionRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    case "view_submission": {
                        slackRequest = new ViewSubmissionRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    case "view_closed": {
                        slackRequest = new ViewClosedRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    default: {
                        log.warn("No request pattern detected for {}", (Object)jsonPayload);
                        break;
                    }
                }
            } else if (this.commandRequestDetector.isCommand(requestBody)) {
                slackRequest = new SlashCommandRequest(requestBody, headers);
            } else if (this.sslCheckPayloadDetector.isSSLCheckRequest(requestBody)) {
                slackRequest = new SSLCheckRequest(requestBody, headers);
            } else if (this.webhookRequestDetector.isWebhook(requestBody)) {
                slackRequest = new OutgoingWebhooksRequest(requestBody, headers);
            } else if (this.appConfig.isOAuthStartEnabled() && this.appConfig.getOauthStartRequestURI().equals(requestUri)) {
                slackRequest = new OAuthStartRequest(requestBody, headers);
            } else if (this.appConfig.isOAuthCallbackEnabled() && this.appConfig.getOauthCallbackRequestURI().equals(requestUri)) {
                Map<String, List<String>> queryString = httpRequest.getQueryString();
                VerificationCodePayload payload = VerificationCodePayload.from(queryString);
                slackRequest = new OAuthCallbackRequest(queryString, requestBody, payload, headers);
            } else {
                log.warn("No request pattern detected for {}", (Object)requestBody);
            }
            Request request = slackRequest;
            return request;
        }
        finally {
            if (slackRequest != null) {
                slackRequest.updateContext(this.appConfig);
                String ipAddress = headers.getFirstValue("X-FORWARDED-FOR");
                if (ipAddress == null) {
                    ipAddress = httpRequest.getRemoteAddress();
                }
                slackRequest.setClientIpAddress(ipAddress);
            }
        }
    }

    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    public JsonPayloadExtractor getJsonPayloadExtractor() {
        return this.jsonPayloadExtractor;
    }

    public SlashCommandPayloadDetector getCommandRequestDetector() {
        return this.commandRequestDetector;
    }

    public SSLCheckPayloadDetector getSslCheckPayloadDetector() {
        return this.sslCheckPayloadDetector;
    }

    public WebhookPayloadDetector getWebhookRequestDetector() {
        return this.webhookRequestDetector;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setJsonPayloadExtractor(JsonPayloadExtractor jsonPayloadExtractor) {
        this.jsonPayloadExtractor = jsonPayloadExtractor;
    }

    public void setCommandRequestDetector(SlashCommandPayloadDetector commandRequestDetector) {
        this.commandRequestDetector = commandRequestDetector;
    }

    public void setSslCheckPayloadDetector(SSLCheckPayloadDetector sslCheckPayloadDetector) {
        this.sslCheckPayloadDetector = sslCheckPayloadDetector;
    }

    public void setWebhookRequestDetector(WebhookPayloadDetector webhookRequestDetector) {
        this.webhookRequestDetector = webhookRequestDetector;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlackRequestParser)) {
            return false;
        }
        SlackRequestParser other = (SlackRequestParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AppConfig this$appConfig = this.getAppConfig();
        AppConfig other$appConfig = other.getAppConfig();
        if (this$appConfig == null ? other$appConfig != null : !((Object)this$appConfig).equals(other$appConfig)) {
            return false;
        }
        JsonPayloadExtractor this$jsonPayloadExtractor = this.getJsonPayloadExtractor();
        JsonPayloadExtractor other$jsonPayloadExtractor = other.getJsonPayloadExtractor();
        if (this$jsonPayloadExtractor == null ? other$jsonPayloadExtractor != null : !this$jsonPayloadExtractor.equals(other$jsonPayloadExtractor)) {
            return false;
        }
        SlashCommandPayloadDetector this$commandRequestDetector = this.getCommandRequestDetector();
        SlashCommandPayloadDetector other$commandRequestDetector = other.getCommandRequestDetector();
        if (this$commandRequestDetector == null ? other$commandRequestDetector != null : !this$commandRequestDetector.equals(other$commandRequestDetector)) {
            return false;
        }
        SSLCheckPayloadDetector this$sslCheckPayloadDetector = this.getSslCheckPayloadDetector();
        SSLCheckPayloadDetector other$sslCheckPayloadDetector = other.getSslCheckPayloadDetector();
        if (this$sslCheckPayloadDetector == null ? other$sslCheckPayloadDetector != null : !this$sslCheckPayloadDetector.equals(other$sslCheckPayloadDetector)) {
            return false;
        }
        WebhookPayloadDetector this$webhookRequestDetector = this.getWebhookRequestDetector();
        WebhookPayloadDetector other$webhookRequestDetector = other.getWebhookRequestDetector();
        if (this$webhookRequestDetector == null ? other$webhookRequestDetector != null : !this$webhookRequestDetector.equals(other$webhookRequestDetector)) {
            return false;
        }
        Gson this$gson = this.getGson();
        Gson other$gson = other.getGson();
        return !(this$gson == null ? other$gson != null : !this$gson.equals(other$gson));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SlackRequestParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AppConfig $appConfig = this.getAppConfig();
        result = result * 59 + ($appConfig == null ? 43 : ((Object)$appConfig).hashCode());
        JsonPayloadExtractor $jsonPayloadExtractor = this.getJsonPayloadExtractor();
        result = result * 59 + ($jsonPayloadExtractor == null ? 43 : $jsonPayloadExtractor.hashCode());
        SlashCommandPayloadDetector $commandRequestDetector = this.getCommandRequestDetector();
        result = result * 59 + ($commandRequestDetector == null ? 43 : $commandRequestDetector.hashCode());
        SSLCheckPayloadDetector $sslCheckPayloadDetector = this.getSslCheckPayloadDetector();
        result = result * 59 + ($sslCheckPayloadDetector == null ? 43 : $sslCheckPayloadDetector.hashCode());
        WebhookPayloadDetector $webhookRequestDetector = this.getWebhookRequestDetector();
        result = result * 59 + ($webhookRequestDetector == null ? 43 : $webhookRequestDetector.hashCode());
        Gson $gson = this.getGson();
        result = result * 59 + ($gson == null ? 43 : $gson.hashCode());
        return result;
    }

    public String toString() {
        return "SlackRequestParser(appConfig=" + this.getAppConfig() + ", jsonPayloadExtractor=" + this.getJsonPayloadExtractor() + ", commandRequestDetector=" + this.getCommandRequestDetector() + ", sslCheckPayloadDetector=" + this.getSslCheckPayloadDetector() + ", webhookRequestDetector=" + this.getWebhookRequestDetector() + ", gson=" + this.getGson() + ")";
    }

    public static class HttpRequest {
        private String requestUri;
        private Map<String, List<String>> queryString;
        private String requestBody;
        private RequestHeaders headers;
        private String remoteAddress;

        HttpRequest(String requestUri, Map<String, List<String>> queryString, String requestBody, RequestHeaders headers, String remoteAddress) {
            this.requestUri = requestUri;
            this.queryString = queryString;
            this.requestBody = requestBody;
            this.headers = headers;
            this.remoteAddress = remoteAddress;
        }

        public static HttpRequestBuilder builder() {
            return new HttpRequestBuilder();
        }

        public String getRequestUri() {
            return this.requestUri;
        }

        public Map<String, List<String>> getQueryString() {
            return this.queryString;
        }

        public String getRequestBody() {
            return this.requestBody;
        }

        public RequestHeaders getHeaders() {
            return this.headers;
        }

        public String getRemoteAddress() {
            return this.remoteAddress;
        }

        public void setRequestUri(String requestUri) {
            this.requestUri = requestUri;
        }

        public void setQueryString(Map<String, List<String>> queryString) {
            this.queryString = queryString;
        }

        public void setRequestBody(String requestBody) {
            this.requestBody = requestBody;
        }

        public void setHeaders(RequestHeaders headers) {
            this.headers = headers;
        }

        public void setRemoteAddress(String remoteAddress) {
            this.remoteAddress = remoteAddress;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpRequest)) {
                return false;
            }
            HttpRequest other = (HttpRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$requestUri = this.getRequestUri();
            String other$requestUri = other.getRequestUri();
            if (this$requestUri == null ? other$requestUri != null : !this$requestUri.equals(other$requestUri)) {
                return false;
            }
            Map<String, List<String>> this$queryString = this.getQueryString();
            Map<String, List<String>> other$queryString = other.getQueryString();
            if (this$queryString == null ? other$queryString != null : !((Object)this$queryString).equals(other$queryString)) {
                return false;
            }
            String this$requestBody = this.getRequestBody();
            String other$requestBody = other.getRequestBody();
            if (this$requestBody == null ? other$requestBody != null : !this$requestBody.equals(other$requestBody)) {
                return false;
            }
            RequestHeaders this$headers = this.getHeaders();
            RequestHeaders other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
                return false;
            }
            String this$remoteAddress = this.getRemoteAddress();
            String other$remoteAddress = other.getRemoteAddress();
            return !(this$remoteAddress == null ? other$remoteAddress != null : !this$remoteAddress.equals(other$remoteAddress));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HttpRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $requestUri = this.getRequestUri();
            result = result * 59 + ($requestUri == null ? 43 : $requestUri.hashCode());
            Map<String, List<String>> $queryString = this.getQueryString();
            result = result * 59 + ($queryString == null ? 43 : ((Object)$queryString).hashCode());
            String $requestBody = this.getRequestBody();
            result = result * 59 + ($requestBody == null ? 43 : $requestBody.hashCode());
            RequestHeaders $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
            String $remoteAddress = this.getRemoteAddress();
            result = result * 59 + ($remoteAddress == null ? 43 : $remoteAddress.hashCode());
            return result;
        }

        public String toString() {
            return "SlackRequestParser.HttpRequest(requestUri=" + this.getRequestUri() + ", queryString=" + this.getQueryString() + ", requestBody=" + this.getRequestBody() + ", headers=" + this.getHeaders() + ", remoteAddress=" + this.getRemoteAddress() + ")";
        }

        public static class HttpRequestBuilder {
            private String requestUri;
            private Map<String, List<String>> queryString;
            private String requestBody;
            private RequestHeaders headers;
            private String remoteAddress;

            HttpRequestBuilder() {
            }

            public HttpRequestBuilder requestUri(String requestUri) {
                this.requestUri = requestUri;
                return this;
            }

            public HttpRequestBuilder queryString(Map<String, List<String>> queryString) {
                this.queryString = queryString;
                return this;
            }

            public HttpRequestBuilder requestBody(String requestBody) {
                this.requestBody = requestBody;
                return this;
            }

            public HttpRequestBuilder headers(RequestHeaders headers) {
                this.headers = headers;
                return this;
            }

            public HttpRequestBuilder remoteAddress(String remoteAddress) {
                this.remoteAddress = remoteAddress;
                return this;
            }

            public HttpRequest build() {
                return new HttpRequest(this.requestUri, this.queryString, this.requestBody, this.headers, this.remoteAddress);
            }

            public String toString() {
                return "SlackRequestParser.HttpRequest.HttpRequestBuilder(requestUri=" + this.requestUri + ", queryString=" + this.queryString + ", requestBody=" + this.requestBody + ", headers=" + this.headers + ", remoteAddress=" + this.remoteAddress + ")";
            }
        }
    }
}

