/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.context.builtin;

import com.slack.api.app_backend.dialogs.response.DialogSubmissionErrorResponse;
import com.slack.api.app_backend.interactive_components.response.ActionResponse;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.context.SayUtility;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.response.ResponseUrlSender;
import com.slack.api.bolt.util.BuilderConfigurator;
import com.slack.api.webhook.WebhookResponse;
import java.io.IOException;

public class DialogSubmissionContext
extends Context
implements SayUtility {
    private String responseUrl;
    private String channelId;
    private ResponseUrlSender responseUrlSender;

    public WebhookResponse respond(ActionResponse response) throws IOException {
        if (this.responseUrlSender == null) {
            this.responseUrlSender = new ResponseUrlSender(this.slack, this.responseUrl);
        }
        return this.responseUrlSender.send(response);
    }

    public WebhookResponse respond(BuilderConfigurator<ActionResponse.ActionResponseBuilder> builder) throws IOException {
        return this.respond(builder.configure(ActionResponse.builder()).build());
    }

    public Response ack(DialogSubmissionErrorResponse error) {
        return this.ackWithJson(error);
    }

    public Response ack(BuilderConfigurator<DialogSubmissionErrorResponse.DialogSubmissionErrorResponseBuilder> builder) {
        return this.ackWithJson(builder.configure(DialogSubmissionErrorResponse.builder()).build());
    }

    public static DialogSubmissionContextBuilder builder() {
        return new DialogSubmissionContextBuilder();
    }

    public String getResponseUrl() {
        return this.responseUrl;
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    public ResponseUrlSender getResponseUrlSender() {
        return this.responseUrlSender;
    }

    public void setResponseUrl(String responseUrl) {
        this.responseUrl = responseUrl;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setResponseUrlSender(ResponseUrlSender responseUrlSender) {
        this.responseUrlSender = responseUrlSender;
    }

    public DialogSubmissionContext() {
    }

    public DialogSubmissionContext(String responseUrl, String channelId, ResponseUrlSender responseUrlSender) {
        this.responseUrl = responseUrl;
        this.channelId = channelId;
        this.responseUrlSender = responseUrlSender;
    }

    @Override
    public String toString() {
        return "DialogSubmissionContext(super=" + super.toString() + ", responseUrl=" + this.getResponseUrl() + ", channelId=" + this.getChannelId() + ", responseUrlSender=" + this.getResponseUrlSender() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DialogSubmissionContext)) {
            return false;
        }
        DialogSubmissionContext other = (DialogSubmissionContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$responseUrl = this.getResponseUrl();
        String other$responseUrl = other.getResponseUrl();
        if (this$responseUrl == null ? other$responseUrl != null : !this$responseUrl.equals(other$responseUrl)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
            return false;
        }
        ResponseUrlSender this$responseUrlSender = this.getResponseUrlSender();
        ResponseUrlSender other$responseUrlSender = other.getResponseUrlSender();
        return !(this$responseUrlSender == null ? other$responseUrlSender != null : !this$responseUrlSender.equals(other$responseUrlSender));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DialogSubmissionContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $responseUrl = this.getResponseUrl();
        result = result * 59 + ($responseUrl == null ? 43 : $responseUrl.hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        ResponseUrlSender $responseUrlSender = this.getResponseUrlSender();
        result = result * 59 + ($responseUrlSender == null ? 43 : $responseUrlSender.hashCode());
        return result;
    }

    public static class DialogSubmissionContextBuilder {
        private String responseUrl;
        private String channelId;
        private ResponseUrlSender responseUrlSender;

        DialogSubmissionContextBuilder() {
        }

        public DialogSubmissionContextBuilder responseUrl(String responseUrl) {
            this.responseUrl = responseUrl;
            return this;
        }

        public DialogSubmissionContextBuilder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public DialogSubmissionContextBuilder responseUrlSender(ResponseUrlSender responseUrlSender) {
            this.responseUrlSender = responseUrlSender;
            return this;
        }

        public DialogSubmissionContext build() {
            return new DialogSubmissionContext(this.responseUrl, this.channelId, this.responseUrlSender);
        }

        public String toString() {
            return "DialogSubmissionContext.DialogSubmissionContextBuilder(responseUrl=" + this.responseUrl + ", channelId=" + this.channelId + ", responseUrlSender=" + this.responseUrlSender + ")";
        }
    }
}

