/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.micronaut;

import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.util.SlackRequestParser;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.server.netty.NettyHttpResponseFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Singleton;

@Singleton
public class SlackAppMicronautAdapter {
    private SlackRequestParser requestParser;
    private NettyHttpResponseFactory micronautResponseFactory = new NettyHttpResponseFactory();

    public SlackAppMicronautAdapter(AppConfig appConfig) {
        this.requestParser = new SlackRequestParser(appConfig);
    }

    public Request<?> toSlackRequest(HttpRequest<?> req, LinkedHashMap<String, String> body) {
        String requestBody = body.entrySet().stream().map(e -> {
            try {
                String k = URLEncoder.encode((String)e.getKey(), "UTF-8");
                String v = URLEncoder.encode((String)e.getValue(), "UTF-8");
                return k + "=" + v;
            }
            catch (UnsupportedEncodingException ex) {
                return (String)e.getKey() + "=" + (String)e.getValue();
            }
        }).collect(Collectors.joining("&"));
        RequestHeaders headers = new RequestHeaders(req.getHeaders().asMap());
        SlackRequestParser.HttpRequest rawRequest = SlackRequestParser.HttpRequest.builder().requestUri(req.getPath()).queryString(req.getParameters().asMap()).headers(headers).requestBody(requestBody).remoteAddress(SlackAppMicronautAdapter.toString(req.getRemoteAddress().getAddress().getAddress())).build();
        return this.requestParser.parse(rawRequest);
    }

    public HttpResponse<String> toMicronautResponse(Response resp) {
        HttpStatus status = HttpStatus.valueOf((int)resp.getStatusCode());
        MutableHttpResponse response = this.micronautResponseFactory.status(status);
        for (Map.Entry header : resp.getHeaders().entrySet()) {
            String name = (String)header.getKey();
            for (String value : (List)header.getValue()) {
                response.header((CharSequence)name, (CharSequence)value);
            }
        }
        response.body((Object)resp.getBody());
        return response;
    }

    private static final String toString(byte[] rawBytes) {
        int i = 4;
        StringBuilder ipAddress = new StringBuilder();
        for (byte raw : rawBytes) {
            ipAddress.append(raw & 0xFF);
            if (--i <= 0) continue;
            ipAddress.append(".");
        }
        return ipAddress.toString();
    }
}

