/*
 * Decompiled with CFR 0.152.
 */
package com.skyline.widget.dialog;

import android.app.Dialog;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.skyline.widget.dialog.R;
import java.util.ArrayList;

public class ActionDialog
extends Dialog
implements View.OnClickListener,
AdapterView.OnItemClickListener {
    private TextView mTextTitle = null;
    private TextView mTextMessage = null;
    private TextView mTextCancel = null;
    private LinearLayout mLayoutHeader = null;
    private RelativeLayout mLayoutCancel = null;
    private ListView mListViewContent = null;
    private ListItemAdapter mListItemAdapter = null;
    private OnEventListener mEventListener = null;
    private ArrayList<ActionItem> mListActionItems = new ArrayList();

    public ActionDialog(Context context) {
        super(context, R.style.SkyActionDialog);
        this.setupViews();
        this.setupWindow();
    }

    public void onClick(View v) {
        if (v == this.mLayoutCancel) {
            this.dismiss();
            if (this.mEventListener != null) {
                this.mEventListener.onCancelItemClick(this);
            }
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (this.mEventListener != null) {
            this.mEventListener.onActionItemClick(this, this.mListActionItems.get(position), position);
        }
        this.dismiss();
    }

    public void setTitle(CharSequence text) {
        super.setTitle(text);
        this.setTitle(text.toString());
    }

    public void setTitle(int textId) {
        super.setTitle(textId);
        this.setTitle(this.getContext().getString(textId));
    }

    public void setTitle(String text) {
        if (!TextUtils.isEmpty((CharSequence)text)) {
            this.mTextTitle.setText((CharSequence)text);
            this.mTextTitle.setVisibility(0);
        } else {
            this.mTextTitle.setVisibility(8);
        }
        this.updateViews();
    }

    public void setMessage(int textId) {
        this.setMessage(this.getContext().getString(textId));
    }

    public void setMessage(CharSequence text) {
        this.setMessage(text.toString());
    }

    public void setMessage(String text) {
        if (!TextUtils.isEmpty((CharSequence)text)) {
            this.mTextMessage.setText((CharSequence)text);
            this.mTextMessage.setVisibility(0);
        } else {
            this.mTextMessage.setVisibility(8);
        }
        this.updateViews();
    }

    public void setCancelText(int textId) {
        this.setCancelText(this.getContext().getString(textId));
    }

    public void setCancelText(CharSequence text) {
        this.setCancelText(text.toString());
    }

    public void setCancelText(String text) {
        this.mTextCancel.setText((CharSequence)text);
    }

    public void setCancelVisible(boolean visible) {
        ((View)this.mLayoutCancel.getParent()).setVisibility(visible ? 0 : 8);
    }

    public void setEventListener(OnEventListener listener) {
        this.mEventListener = listener;
    }

    public void addAction(ActionItem item) {
        this.mListActionItems.add(item);
    }

    public void addAction(int textId) {
        this.addAction(this.getContext().getString(textId));
    }

    public void addAction(String title) {
        this.addAction(title, null);
    }

    public void addAction(String title, Object key) {
        ActionItem item = new ActionItem();
        item.title = title;
        item.key = key;
        this.mListActionItems.add(item);
        this.mListItemAdapter.notifyDataSetChanged();
    }

    public void addAction(String title, boolean destructive) {
        ActionItem item = new ActionItem();
        item.title = title;
        item.destructive = destructive;
        this.mListActionItems.add(item);
        this.mListItemAdapter.notifyDataSetChanged();
    }

    public void setActions(int arrayId) {
        this.setActions(this.getContext().getResources().getStringArray(arrayId));
    }

    public void setActions(String[] titles) {
        this.mListActionItems.clear();
        for (String title : titles) {
            this.addAction(title);
        }
    }

    public void clearActions() {
        this.mListActionItems.clear();
        this.mListItemAdapter.notifyDataSetChanged();
    }

    private void setupViews() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        View viewContent = inflater.inflate(R.layout.sky_dialog_action, null);
        this.setContentView(viewContent);
        this.mLayoutHeader = (LinearLayout)viewContent.findViewById(R.id.sky_action_dialog_layout_header);
        this.mLayoutHeader.setVisibility(8);
        this.mTextTitle = (TextView)viewContent.findViewById(R.id.sky_action_dialog_text_title);
        this.mTextTitle.setVisibility(8);
        this.mTextMessage = (TextView)viewContent.findViewById(R.id.sky_action_dialog_text_message);
        this.mTextMessage.setVisibility(8);
        this.mListItemAdapter = new ListItemAdapter(this.getContext(), this.mListActionItems);
        this.mListViewContent = (ListView)viewContent.findViewById(R.id.sky_action_dialog_list_content);
        this.mListViewContent.setAdapter((ListAdapter)this.mListItemAdapter);
        this.mListViewContent.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mLayoutCancel = (RelativeLayout)viewContent.findViewById(R.id.sky_action_dialog_layout_cancel);
        this.mLayoutCancel.setOnClickListener((View.OnClickListener)this);
        this.mTextCancel = (TextView)viewContent.findViewById(R.id.sky_action_dialog_text_cancel);
    }

    private void updateViews() {
        if (this.mTextTitle.getVisibility() == 0 || this.mTextMessage.getVisibility() == 0) {
            this.mLayoutHeader.setVisibility(0);
        } else {
            this.mLayoutHeader.setVisibility(8);
        }
    }

    private void setupWindow() {
        Window window = this.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.width = this.getContext().getResources().getDisplayMetrics().widthPixels;
        window.setAttributes(layoutParams);
        window.setGravity(80);
    }

    public static interface OnEventListener {
        public void onActionItemClick(ActionDialog var1, ActionItem var2, int var3);

        public void onCancelItemClick(ActionDialog var1);
    }

    private class ListItemAdapter
    extends ArrayAdapter<ActionItem> {
        private LayoutInflater mLayoutInflater;

        public ListItemAdapter(Context context, ArrayList<ActionItem> items) {
            super(context, 0, items);
            this.mLayoutInflater = null;
            this.mLayoutInflater = LayoutInflater.from((Context)this.getContext());
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = this.mLayoutInflater.inflate(R.layout.sky_list_item_action, parent, false);
            }
            ActionItem item = (ActionItem)this.getItem(position);
            TextView textTitle = (TextView)convertView.findViewById(R.id.sky_action_item_text_title);
            textTitle.setText((CharSequence)item.title);
            if (item.destructive) {
                textTitle.setTextColor(this.getColor(R.color.sky_action_dialog_red));
            } else {
                textTitle.setTextColor(this.getColor(R.color.sky_action_dialog_blue));
            }
            return convertView;
        }

        private int getColor(int colorId) {
            return this.getContext().getResources().getColor(colorId);
        }
    }

    public static class ActionItem {
        public boolean destructive = false;
        public String title = null;
        public Object key = 0;
    }
}

