/*
 * Decompiled with CFR 0.152.
 */
package com.skyfishjy.library;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.RelativeLayout;
import com.skyfishjy.library.R;
import java.util.ArrayList;

public class RippleBackground
extends RelativeLayout {
    private static final int DEFAULT_RIPPLE_COUNT = 6;
    private static final int DEFAULT_DURATION_TIME = 3000;
    private static final float DEFAULT_SCALE = 6.0f;
    private static final int DEFAULT_FILL_TYPE = 0;
    private int rippleColor;
    private float rippleStrokeWidth;
    private float rippleRadius;
    private int rippleDurationTime;
    private int rippleAmount;
    private int rippleDelay;
    private float rippleScale;
    private int rippleType;
    private Paint paint;
    private boolean animationRunning = false;
    private AnimatorSet animatorSet;
    private ArrayList<Animator> animatorList;
    private RelativeLayout.LayoutParams rippleParams;
    private ArrayList<RippleView> rippleViewList = new ArrayList();

    public RippleBackground(Context context) {
        super(context);
    }

    public RippleBackground(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public RippleBackground(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (this.isInEditMode()) {
            return;
        }
        if (null == attrs) {
            throw new IllegalArgumentException("Attributes should be provided to this view,");
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RippleBackground);
        this.rippleColor = typedArray.getColor(R.styleable.RippleBackground_rb_color, this.getResources().getColor(R.color.rippelColor));
        this.rippleStrokeWidth = typedArray.getDimension(R.styleable.RippleBackground_rb_strokeWidth, this.getResources().getDimension(R.dimen.rippleStrokeWidth));
        this.rippleRadius = typedArray.getDimension(R.styleable.RippleBackground_rb_radius, this.getResources().getDimension(R.dimen.rippleRadius));
        this.rippleDurationTime = typedArray.getInt(R.styleable.RippleBackground_rb_duration, 3000);
        this.rippleAmount = typedArray.getInt(R.styleable.RippleBackground_rb_rippleAmount, 6);
        this.rippleScale = typedArray.getFloat(R.styleable.RippleBackground_rb_scale, 6.0f);
        this.rippleType = typedArray.getInt(R.styleable.RippleBackground_rb_type, 0);
        typedArray.recycle();
        this.rippleDelay = this.rippleDurationTime / this.rippleAmount;
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        if (this.rippleType == 0) {
            this.rippleStrokeWidth = 0.0f;
            this.paint.setStyle(Paint.Style.FILL);
        } else {
            this.paint.setStyle(Paint.Style.STROKE);
        }
        this.paint.setColor(this.rippleColor);
        this.rippleParams = new RelativeLayout.LayoutParams((int)(2.0f * (this.rippleRadius + this.rippleStrokeWidth)), (int)(2.0f * (this.rippleRadius + this.rippleStrokeWidth)));
        this.rippleParams.addRule(13, -1);
        this.animatorSet = new AnimatorSet();
        this.animatorSet.setDuration((long)this.rippleDurationTime);
        this.animatorSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.animatorList = new ArrayList();
        for (int i = 0; i < this.rippleAmount; ++i) {
            RippleView rippleView = new RippleView(this.getContext());
            this.addView(rippleView, (ViewGroup.LayoutParams)this.rippleParams);
            this.rippleViewList.add(rippleView);
            ObjectAnimator scaleXAnimator = ObjectAnimator.ofFloat((Object)((Object)rippleView), (String)"ScaleX", (float[])new float[]{1.0f, this.rippleScale});
            scaleXAnimator.setRepeatCount(-1);
            scaleXAnimator.setRepeatMode(1);
            scaleXAnimator.setStartDelay((long)(i * this.rippleDelay));
            this.animatorList.add((Animator)scaleXAnimator);
            ObjectAnimator scaleYAnimator = ObjectAnimator.ofFloat((Object)((Object)rippleView), (String)"ScaleY", (float[])new float[]{1.0f, this.rippleScale});
            scaleYAnimator.setRepeatCount(-1);
            scaleYAnimator.setRepeatMode(1);
            scaleYAnimator.setStartDelay((long)(i * this.rippleDelay));
            this.animatorList.add((Animator)scaleYAnimator);
            ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)((Object)rippleView), (String)"Alpha", (float[])new float[]{1.0f, 0.0f});
            alphaAnimator.setRepeatCount(-1);
            alphaAnimator.setRepeatMode(1);
            alphaAnimator.setStartDelay((long)(i * this.rippleDelay));
            this.animatorList.add((Animator)alphaAnimator);
        }
        this.animatorSet.playTogether(this.animatorList);
    }

    public void startRippleAnimation() {
        if (!this.isRippleAnimationRunning()) {
            for (RippleView rippleView : this.rippleViewList) {
                rippleView.setVisibility(0);
            }
            this.animatorSet.start();
            this.animationRunning = true;
        }
    }

    public void stopRippleAnimation() {
        if (this.isRippleAnimationRunning()) {
            this.animatorSet.end();
            this.animationRunning = false;
        }
    }

    public boolean isRippleAnimationRunning() {
        return this.animationRunning;
    }

    private class RippleView
    extends View {
        public RippleView(Context context) {
            super(context);
            this.setVisibility(4);
        }

        protected void onDraw(Canvas canvas) {
            int radius = Math.min(this.getWidth(), this.getHeight()) / 2;
            canvas.drawCircle((float)radius, (float)radius, (float)radius - RippleBackground.this.rippleStrokeWidth, RippleBackground.this.paint);
        }
    }
}

