/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.message.server;

import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.context.Context;
import com.singlestore.jdbc.message.server.Completion;
import com.singlestore.jdbc.util.log.Logger;
import com.singlestore.jdbc.util.log.Loggers;

public class OkPacket
implements Completion {
    private static final Logger logger = Loggers.getLogger(OkPacket.class);
    private final long affectedRows;
    private final long lastInsertId;

    public OkPacket(ReadableByteBuf buf, Context context) {
        buf.skip();
        this.affectedRows = buf.readLengthNotNull();
        this.lastInsertId = buf.readLengthNotNull();
        context.setServerStatus(buf.readUnsignedShort());
        context.setWarning(buf.readUnsignedShort());
        if ((context.getServerCapabilities() & 0x800000L) != 0L && buf.readableBytes() > 0) {
            buf.skip(buf.readLengthNotNull());
            block4: while (buf.readableBytes() > 0) {
                if (buf.readLengthNotNull() <= 0) continue;
                switch (buf.readByte()) {
                    case 0: {
                        buf.readLengthNotNull();
                        String variable = buf.readString(buf.readLengthNotNull());
                        Integer len = buf.readLength();
                        String value = len == null ? null : buf.readString(len);
                        logger.debug("System variable change:  {} = {}", variable, value);
                        continue block4;
                    }
                    case 1: {
                        buf.readLengthNotNull();
                        Integer dbLen = buf.readLength();
                        String database = dbLen == null ? null : buf.readString(dbLen);
                        context.setDatabase(database.isEmpty() ? null : database);
                        logger.debug("Database change: is '{}'", database);
                        continue block4;
                    }
                }
                buf.skip(buf.readLengthNotNull());
            }
        }
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public long getLastInsertId() {
        return this.lastInsertId;
    }
}

