/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.codec;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.codec.Codec;
import com.singlestore.jdbc.message.server.ColumnDefinitionPacket;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class RowDecoder {
    protected static final int NULL_LENGTH = -1;
    private final Configuration conf;
    protected final ReadableByteBuf readBuf = new ReadableByteBuf(null, null, 0);
    protected final ColumnDefinitionPacket[] columns;
    protected int length;
    protected int index;
    protected final int columnCount;
    private Map<String, Integer> mapper = null;

    public RowDecoder(int columnCount, ColumnDefinitionPacket[] columns, Configuration conf) {
        this.columnCount = columnCount;
        this.columns = columns;
        this.conf = conf;
    }

    public void setRow(byte[] buf) {
        this.readBuf.buf(buf, buf == null ? 0 : buf.length).pos(0);
        this.index = -1;
    }

    public abstract void setPosition(int var1);

    public abstract <T> T decode(Codec<T> var1, Calendar var2) throws SQLException;

    public abstract byte decodeByte() throws SQLException;

    public abstract boolean decodeBoolean() throws SQLException;

    public abstract short decodeShort() throws SQLException;

    public abstract int decodeInt() throws SQLException;

    public abstract long decodeLong() throws SQLException;

    public abstract float decodeFloat() throws SQLException;

    public abstract double decodeDouble() throws SQLException;

    public <T> T getValue(int index, Class<T> type, Calendar calendar) throws SQLException {
        this.checkIndexAndSetPosition(index);
        if (this.wasNull()) {
            if (type.isPrimitive()) {
                throw new SQLException(String.format("Cannot return null for primitive %s", type.getName()));
            }
            return null;
        }
        ColumnDefinitionPacket column = this.columns[index - 1];
        if (Object.class.equals(type) || type == null) {
            Codec<?> defaultCodec = column.getDefaultCodec(this.conf);
            return (T)this.decode(defaultCodec, calendar);
        }
        for (Codec<T> codec : this.conf.codecs()) {
            if (!codec.canDecode(column, type)) continue;
            return (T)this.decode(codec, calendar);
        }
        this.readBuf.skip(this.length);
        throw new SQLException(String.format("Type %s not supported type for %s type", type, column.getTypeName()));
    }

    public abstract boolean wasNull();

    private void checkIndexAndSetPosition(int index) throws SQLException {
        if (index < 1 || index > this.columnCount) {
            throw new SQLException(String.format("Wrong index position. Is %s but must be in 1-%s range", index, this.columnCount));
        }
        if (this.readBuf.buf() == null) {
            throw new SQLDataException("wrong row position", "22023");
        }
        this.setPosition(index - 1);
    }

    public <T> T getValue(int index, Codec<T> codec, Calendar cal) throws SQLException {
        this.checkIndexAndSetPosition(index);
        if (this.length == -1) {
            return null;
        }
        return this.decode(codec, cal);
    }

    public byte getByteValue(int index) throws SQLException {
        this.checkIndexAndSetPosition(index);
        if (this.length == -1) {
            return 0;
        }
        return this.decodeByte();
    }

    public boolean getBooleanValue(int index) throws SQLException {
        this.checkIndexAndSetPosition(index);
        if (this.length == -1) {
            return false;
        }
        return this.decodeBoolean();
    }

    public short getShortValue(int index) throws SQLException {
        this.checkIndexAndSetPosition(index);
        if (this.length == -1) {
            return 0;
        }
        return this.decodeShort();
    }

    public int getIntValue(int index) throws SQLException {
        this.checkIndexAndSetPosition(index);
        if (this.length == -1) {
            return 0;
        }
        return this.decodeInt();
    }

    public long getLongValue(int index) throws SQLException {
        this.checkIndexAndSetPosition(index);
        if (this.length == -1) {
            return 0L;
        }
        return this.decodeLong();
    }

    public float getFloatValue(int index) throws SQLException {
        this.checkIndexAndSetPosition(index);
        if (this.length == -1) {
            return 0.0f;
        }
        return this.decodeFloat();
    }

    public double getDoubleValue(int index) throws SQLException {
        this.checkIndexAndSetPosition(index);
        if (this.length == -1) {
            return 0.0;
        }
        return this.decodeDouble();
    }

    public <T> T getValue(String label, Codec<T> codec, Calendar cal) throws SQLException {
        return this.getValue(this.getIndex(label), codec, cal);
    }

    public int getIndex(String label) throws SQLException {
        Integer ind;
        if (label == null) {
            throw new SQLException("null is not a valid label value");
        }
        if (this.mapper == null) {
            this.mapper = new HashMap<String, Integer>();
            for (int i = 0; i < this.columnCount; ++i) {
                ColumnDefinitionPacket ci = this.columns[i];
                String columnAlias = ci.getColumnAlias();
                if (columnAlias == null) continue;
                columnAlias = columnAlias.toLowerCase(Locale.ROOT);
                this.mapper.putIfAbsent(columnAlias, i + 1);
                String tableAlias = ci.getTableAlias();
                if (tableAlias != null) {
                    this.mapper.putIfAbsent(tableAlias.toLowerCase(Locale.ROOT) + "." + columnAlias, i + 1);
                    continue;
                }
                String table = ci.getTable();
                if (table == null) continue;
                this.mapper.putIfAbsent(table.toLowerCase(Locale.ROOT) + "." + columnAlias, i + 1);
            }
        }
        if ((ind = this.mapper.get(label.toLowerCase(Locale.ROOT))) == null) {
            String keys = Arrays.toString(this.mapper.keySet().toArray(new String[0]));
            throw new SQLException(String.format("Unknown label '%s'. Possible value %s", label, keys));
        }
        return ind;
    }
}

