/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.fourstate;

import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.AbstractVariableHeightLogicHandler;
import org.krysalis.barcode4j.impl.HeightVariableBarcodeBean;
import org.krysalis.barcode4j.output.Canvas;

public class FourStateLogicHandler
extends AbstractVariableHeightLogicHandler {
    public FourStateLogicHandler(HeightVariableBarcodeBean bcBean, Canvas canvas) {
        super(bcBean, canvas);
    }

    private double getStartY() {
        double y = 0.0;
        if (this.bcBean.hasQuietZone()) {
            y += this.bcBean.getVerticalQuietZone();
        }
        if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
            y += this.bcBean.getHumanReadableHeight();
        }
        return y;
    }

    @Override
    public void addBar(boolean black, int height) {
        double y1;
        double w = this.bcBean.getBarWidth(1);
        double h = this.bcBean.getBarHeight(height);
        double middle = this.bcBean.getBarHeight() / 2.0;
        switch (height) {
            case 0: 
            case 2: {
                y1 = middle - this.bcBean.getBarHeight(0) / 2.0;
                break;
            }
            case 1: 
            case 3: {
                y1 = middle - this.bcBean.getBarHeight(3) / 2.0;
                break;
            }
            default: {
                throw new RuntimeException("Bug!");
            }
        }
        this.canvas.drawRectWH(this.x, this.getStartY() + y1, w, h);
        this.x += w + this.bcBean.getBarWidth(-1);
    }
}

