/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.datamatrix;

import java.awt.Dimension;
import java.io.IOException;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.DefaultTwoDimCanvasLogicHandler;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrixHighLevelEncoder;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrixLogicImpl;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrixSymbolInfo;
import org.krysalis.barcode4j.impl.datamatrix.SymbolShapeHint;
import org.krysalis.barcode4j.output.Canvas;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.tools.UnitConv;

public class DataMatrixBean
extends AbstractBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = UnitConv.in2mm(0.013888888888888888);
    private SymbolShapeHint shape;
    private Dimension minSize;
    private Dimension maxSize;

    public DataMatrixBean() {
        this.height = 0.0;
        this.moduleWidth = DEFAULT_MODULE_WIDTH;
        this.setQuietZone(1.0 * this.moduleWidth);
        this.shape = SymbolShapeHint.FORCE_NONE;
    }

    public void setShape(SymbolShapeHint shape) {
        this.shape = shape;
    }

    public SymbolShapeHint getShape() {
        return this.shape;
    }

    public void setMinSize(Dimension minSize) {
        this.minSize = minSize != null ? new Dimension(minSize) : null;
    }

    public Dimension getMinSize() {
        if (this.minSize != null) {
            return new Dimension(this.minSize);
        }
        return null;
    }

    public void setMaxSize(Dimension maxSize) {
        this.maxSize = maxSize != null ? new Dimension(maxSize) : null;
    }

    public Dimension getMaxSize() {
        if (this.maxSize != null) {
            return new Dimension(this.maxSize);
        }
        return null;
    }

    @Override
    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultTwoDimCanvasLogicHandler handler = new DefaultTwoDimCanvasLogicHandler(this, new Canvas(canvas));
        DataMatrixLogicImpl impl = new DataMatrixLogicImpl();
        impl.generateBarcodeLogic(handler, msg, this.getShape(), this.getMinSize(), this.getMaxSize());
    }

    @Override
    public BarcodeDimension calcDimensions(String msg) {
        String encoded;
        try {
            encoded = DataMatrixHighLevelEncoder.encodeHighLevel(msg, this.shape, this.getMinSize(), this.getMaxSize());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot fetch data: " + e.getLocalizedMessage());
        }
        DataMatrixSymbolInfo symbolInfo = DataMatrixSymbolInfo.lookup(encoded.length(), this.shape);
        double width = (double)symbolInfo.getSymbolWidth() * this.getModuleWidth();
        double height = (double)symbolInfo.getSymbolHeight() * this.getBarHeight();
        double qzh = this.hasQuietZone() ? this.getQuietZone() : 0.0;
        double qzv = this.hasQuietZone() ? this.getVerticalQuietZone() : 0.0;
        return new BarcodeDimension(width, height, width + 2.0 * qzh, height + 2.0 * qzv, qzh, qzv);
    }

    @Override
    public double getVerticalQuietZone() {
        return this.getQuietZone();
    }

    @Override
    public double getBarWidth(int width) {
        return this.moduleWidth;
    }

    @Override
    public double getBarHeight() {
        return this.moduleWidth;
    }
}

