/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.codabar;

import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.DefaultCanvasLogicHandler;
import org.krysalis.barcode4j.impl.codabar.CodabarLogicImpl;
import org.krysalis.barcode4j.output.Canvas;
import org.krysalis.barcode4j.output.CanvasProvider;

public class CodabarBean
extends AbstractBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = (double)0.21f;
    protected static final double DEFAULT_WIDE_FACTOR = 3.0;
    protected static final boolean DEFAULT_DISPLAY_START_STOP = false;
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private boolean displayStartStop = false;
    private double wideFactor = 3.0;

    public CodabarBean() {
        this.moduleWidth = 0.21f;
        this.setQuietZone(10.0 * this.moduleWidth);
        this.setVerticalQuietZone(0.0);
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public void setChecksumMode(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public double getWideFactor() {
        return this.wideFactor;
    }

    public void setWideFactor(double value) {
        if (value <= 1.0) {
            throw new IllegalArgumentException("wide factor must be > 1.0");
        }
        this.wideFactor = value;
    }

    @Override
    public double getBarWidth(int width) {
        if (width == 1) {
            return this.moduleWidth;
        }
        if (width == 2) {
            return this.moduleWidth * this.wideFactor;
        }
        throw new IllegalArgumentException("Only widths 1 and 2 allowed");
    }

    public boolean isDisplayStartStop() {
        return this.displayStartStop;
    }

    public void setDisplayStartStop(boolean value) {
        this.displayStartStop = value;
    }

    @Override
    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultCanvasLogicHandler handler = new DefaultCanvasLogicHandler(this, new Canvas(canvas));
        CodabarLogicImpl impl = new CodabarLogicImpl(this.getChecksumMode(), this.isDisplayStartStop());
        impl.generateBarcodeLogic(handler, msg);
    }

    private double calcCharWidth(char c) {
        int idx = CodabarLogicImpl.getCharIndex(c);
        if (idx >= 0) {
            int narrow = 0;
            int wide = 0;
            for (int i = 0; i < 7; ++i) {
                byte width = CodabarLogicImpl.CHARSET[idx][i];
                if (width == 0) {
                    ++narrow;
                    continue;
                }
                ++wide;
            }
            return (double)narrow * this.moduleWidth + (double)wide * this.moduleWidth * this.wideFactor;
        }
        throw new IllegalArgumentException("Invalid character: " + c);
    }

    @Override
    public BarcodeDimension calcDimensions(String msg) {
        double width = 0.0;
        for (int i = 0; i < msg.length(); ++i) {
            if (i > 0) {
                width += this.moduleWidth;
            }
            width += this.calcCharWidth(msg.charAt(i));
        }
        double qz = this.hasQuietZone() ? this.quietZone : 0.0;
        return new BarcodeDimension(width, this.getHeight(), width + 2.0 * qz, this.getHeight(), this.quietZone, 0.0);
    }
}

