/*
 * Decompiled with CFR 0.152.
 */
package com.sim.scar;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.util.Log;
import com.sim.scar.ReceiveListener;
import com.sim.scar.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SmsContentObserver
extends ContentObserver {
    private static final String TAG = "SMS_CONETNT_OBSERVER";
    private static final long SCAN_SMS_TIME = 300000L;
    private final Context context;
    private final String[] smsContents;
    private final ReceiveListener callback;
    private final Pattern pattern;

    public SmsContentObserver(Handler handler, Context context, String[] tags, ReceiveListener callback) {
        super(handler);
        if (context == null || callback == null || handler == null || Utils.isBlank(tags).booleanValue()) {
            throw new NullPointerException("SmsContentObserver Construction's Parameter should NOT be null");
        }
        this.context = context;
        this.smsContents = tags;
        this.callback = callback;
        this.pattern = Pattern.compile("\\d{4,8}");
    }

    public SmsContentObserver(Handler handler, Context context, String[] tags, ReceiveListener callback, Pattern pattern) {
        super(handler);
        if (context == null || callback == null || handler == null || Utils.isBlank(tags).booleanValue()) {
            throw new NullPointerException("SmsContentObserver Construction's Parameter should NOT be null");
        }
        this.context = context;
        this.smsContents = tags;
        this.callback = callback;
        this.pattern = pattern;
    }

    public void registerSMSObserver() {
        this.context.getContentResolver().registerContentObserver(Uri.parse((String)"content://sms/"), true, (ContentObserver)this);
    }

    public void unregisterSMSObserver() {
        this.context.getContentResolver().unregisterContentObserver((ContentObserver)this);
    }

    public void onChange(boolean selfChange) {
        super.onChange(selfChange);
        this.querySms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void querySms() {
        Uri uri = Uri.parse((String)"content://sms/inbox");
        ContentResolver contentResolver = this.context.getContentResolver();
        String[] projection = new String[]{"body", "_id", "date"};
        String sqlWhere = this.getSqlWhere();
        if (sqlWhere == null || sqlWhere.equals("")) {
            return;
        }
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(uri, projection, sqlWhere, null, null);
            int i = -1;
            long time = 0L;
            while (cursor.moveToNext()) {
                long smsDate = cursor.getLong(2);
                if (smsDate <= time) continue;
                time = smsDate;
                i = cursor.getPosition();
            }
            if (i >= 0) {
                cursor.moveToPosition(i);
                String smsBody = cursor.getString(cursor.getColumnIndex("body"));
                String observedVerifyNum = this.getVerifyNumFromSms(smsBody);
                this.callback.onReceived(observedVerifyNum);
            } else {
                this.callback.onReceived(null);
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"querySms error");
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    private String getSqlWhere() {
        String sqlWhere = "( ";
        for (int i = 0; i < this.smsContents.length; ++i) {
            sqlWhere = i == this.smsContents.length - 1 ? sqlWhere + " body like \"%" + this.smsContents[i] + "%\" ) " : sqlWhere + "body like \"%" + this.smsContents[i] + "%\" or ";
        }
        sqlWhere = sqlWhere + " and date > " + (System.currentTimeMillis() - 300000L) + " ";
        Log.v((String)TAG, (String)("sql where:" + sqlWhere));
        return sqlWhere;
    }

    private String getVerifyNumFromSms(String smsBody) {
        Matcher m = this.pattern.matcher(smsBody);
        if (m.find()) {
            return m.group();
        }
        return null;
    }
}

