/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd;

import com.jme3.math.Vector4f;
import java.io.Serializable;

public final class Vec4d
implements Cloneable,
Serializable {
    static final long serialVersionUID = 42L;
    public double x;
    public double y;
    public double z;
    public double w;

    public Vec4d() {
    }

    public Vec4d(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vec4d(Vec4d v) {
        this(v.x, v.y, v.z, v.w);
    }

    public Vec4d(Vector4f v) {
        this(v.x, v.y, v.z, v.w);
    }

    public Vector4f toVector4f() {
        return new Vector4f((float)this.x, (float)this.y, (float)this.z, (float)this.w);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.x);
        bits ^= Double.doubleToLongBits(this.y) * 31L;
        bits ^= Double.doubleToLongBits(this.z) * 31L;
        return (int)(bits ^= Double.doubleToLongBits(this.w) * 31L) ^ (int)(bits >> 32);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Vec4d other = (Vec4d)o;
        if (other.x != this.x) {
            return false;
        }
        if (other.y != this.y) {
            return false;
        }
        if (other.z != this.z) {
            return false;
        }
        return other.w == this.w;
    }

    public final Vec4d set(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public final Vec4d set(Vec4d v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = v.w;
        return this;
    }

    public final Vec4d clone() {
        return new Vec4d(this.x, this.y, this.z, this.w);
    }

    public double get(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IndexOutOfBoundsException("Index:" + i);
    }

    public Vec4d set(int i, double d) {
        switch (i) {
            case 0: {
                this.x = d;
                break;
            }
            case 1: {
                this.y = d;
                break;
            }
            case 2: {
                this.z = d;
                break;
            }
            case 3: {
                this.w = d;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Index:" + i);
            }
        }
        return this;
    }

    public final Vec4d add(Vec4d v) {
        return new Vec4d(this.x + v.x, this.y + v.y, this.z + v.z, this.w + v.w);
    }

    public final Vec4d add(double vx, double vy, double vz, double vw) {
        return new Vec4d(this.x + vx, this.y + vy, this.z + vz, this.w + vw);
    }

    public final Vec4d subtract(Vec4d v) {
        return new Vec4d(this.x - v.x, this.y - v.y, this.z - v.z, this.w - v.w);
    }

    public final Vec4d subtract(double vx, double vy, double vz, double vw) {
        return new Vec4d(this.x - vx, this.y - vy, this.z - vz, this.w - vw);
    }

    public final Vec4d mult(double s) {
        return new Vec4d(this.x * s, this.y * s, this.z * s, this.w * s);
    }

    public final Vec4d mult(Vec4d v) {
        return new Vec4d(this.x * v.x, this.y * v.y, this.z * v.z, this.w * v.w);
    }

    public final Vec4d divide(double s) {
        return new Vec4d(this.x / s, this.y / s, this.z / s, this.w / s);
    }

    public final Vec4d divide(Vec4d v) {
        return new Vec4d(this.x / v.x, this.y / v.y, this.z / v.z, this.w / v.w);
    }

    public final Vec4d addLocal(Vec4d v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        this.w += v.w;
        return this;
    }

    public final Vec4d addLocal(double vx, double vy, double vz, double vw) {
        this.x += vx;
        this.y += vy;
        this.z += vz;
        this.w += vw;
        return this;
    }

    public final Vec4d subtractLocal(Vec4d v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        this.w -= v.w;
        return this;
    }

    public final Vec4d subtractLocal(double vx, double vy, double vz, double vw) {
        this.x -= vx;
        this.y -= vy;
        this.z -= vz;
        this.w -= vw;
        return this;
    }

    public final Vec4d multLocal(double s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
        this.w *= s;
        return this;
    }

    public final Vec4d multLocal(Vec4d v) {
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
        this.w *= v.w;
        return this;
    }

    public final Vec4d divideLocal(double s) {
        this.x /= s;
        this.y /= s;
        this.z /= s;
        this.w /= s;
        return this;
    }

    public final Vec4d divideLocal(Vec4d v) {
        this.x /= v.x;
        this.y /= v.y;
        this.z /= v.z;
        this.w /= v.w;
        return this;
    }

    public final double lengthSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public final double length() {
        return Math.sqrt(this.lengthSq());
    }

    public final double distanceSq(Vec4d v) {
        double xs = v.x - this.x;
        double ys = v.y - this.y;
        double zs = v.z - this.z;
        double ws = v.w - this.w;
        return xs * xs + ys * ys + zs * zs + ws * ws;
    }

    public final double distance(Vec4d v) {
        return Math.sqrt(this.distanceSq(v));
    }

    public final Vec4d normalize() {
        return this.mult(1.0 / this.length());
    }

    public final Vec4d normalizeLocal() {
        return this.multLocal(1.0 / this.length());
    }

    public final double dot(Vec4d v) {
        return this.x * v.x + this.y * v.y + this.z * v.z + this.w * v.w;
    }

    public final double dot(double vx, double vy, double vz, double vw) {
        return this.x * vx + this.y * vy + this.z * vz + this.w * vw;
    }

    public final Vec4d addScaledVectorLocal(Vec4d toAdd, double scale) {
        this.x += toAdd.x * scale;
        this.y += toAdd.y * scale;
        this.z += toAdd.z * scale;
        this.w += toAdd.w * scale;
        return this;
    }

    public final Vec4d minLocal(Vec4d v) {
        this.x = this.x < v.x ? this.x : v.x;
        this.y = this.y < v.y ? this.y : v.y;
        this.z = this.z < v.z ? this.z : v.z;
        this.w = this.w < v.w ? this.w : v.w;
        return this;
    }

    public final Vec4d maxLocal(Vec4d v) {
        this.x = this.x > v.x ? this.x : v.x;
        this.y = this.y > v.y ? this.y : v.y;
        this.z = this.z > v.z ? this.z : v.z;
        this.w = this.w > v.w ? this.w : v.w;
        return this;
    }

    public final Vec4d zeroEpsilon(double e) {
        if (this.x > -e && this.x < e) {
            this.x = 0.0;
        }
        if (this.y > -e && this.y < e) {
            this.y = 0.0;
        }
        if (this.z > -e && this.z < e) {
            this.z = 0.0;
        }
        if (this.w > -e && this.w < e) {
            this.w = 0.0;
        }
        return this;
    }

    public String toString() {
        return "Vec3[" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + "]";
    }
}

