/*
 * Decompiled with CFR 0.152.
 */
package com.simplepeng.updaterlibrary;

import android.app.Activity;
import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.simplepeng.updaterlibrary.DownloadObserver;
import com.simplepeng.updaterlibrary.DownloadReceiver;
import com.simplepeng.updaterlibrary.LogUtils;
import com.simplepeng.updaterlibrary.ProgressListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import pub.devrel.easypermissions.EasyPermissions;

public class Updater {
    private String apkName;
    private String apkPath;
    private String apkDirName;
    private String title;
    private String downloadUrl;
    private Activity context;
    private DownloadManager downloadManager;
    private long mTaskId;
    private boolean hideNotification = false;
    private boolean allowedOverRoaming = false;
    private DownloadReceiver downloadReceiver;
    private DownloadObserver downloadObserver;
    private boolean claerCache = false;
    private String[] perms = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
    private static final int RC_SDCARD = 123;
    private ArrayList<ProgressListener> listeners;
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            Bundle data = msg.getData();
            long cutBytes = data.getLong("curBytes");
            long totalBytes = data.getLong("totalBytes");
            int progress = data.getInt("progress");
            if (Updater.this.listeners != null && !Updater.this.listeners.isEmpty()) {
                for (ProgressListener listener : Updater.this.listeners) {
                    listener.onProgressChange(totalBytes, cutBytes, progress);
                }
            }
            return false;
        }
    });

    private Updater(Activity context) {
        this.context = context;
    }

    private void download() {
        if (this.context == null) {
            throw new NullPointerException("context must not be null");
        }
        if (TextUtils.isEmpty((CharSequence)this.downloadUrl)) {
            throw new NullPointerException("downloadUrl must not be null");
        }
        if (!EasyPermissions.hasPermissions((Context)this.context, (String[])this.perms)) {
            EasyPermissions.requestPermissions((Object)this.context, (String)"updater \u9700\u8981sd\u5361\u6743\u9650", (int)123, (String[])this.perms);
            return;
        }
        if (this.downloadManager == null) {
            this.downloadManager = (DownloadManager)this.context.getSystemService("download");
        }
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)this.downloadUrl));
        request.setAllowedNetworkTypes(3);
        request.setAllowedOverRoaming(this.allowedOverRoaming);
        request.setTitle((CharSequence)(TextUtils.isEmpty((CharSequence)this.title) ? this.apkName : this.title));
        request.setNotificationVisibility(this.hideNotification ? 2 : 0);
        if (TextUtils.isEmpty((CharSequence)this.apkPath) && TextUtils.isEmpty((CharSequence)this.apkDirName)) {
            request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, this.apkName);
        } else if (!TextUtils.isEmpty((CharSequence)this.apkDirName)) {
            request.setDestinationInExternalPublicDir(this.apkDirName, this.apkName);
        } else {
            String apkAbsPath = this.apkPath + File.separator + this.apkName;
            request.setDestinationUri(Uri.fromFile((File)new File(apkAbsPath)));
        }
        this.mTaskId = this.downloadManager.enqueue(request);
    }

    public void registerDownloadReceiver() {
        if (this.downloadReceiver == null) {
            this.downloadReceiver = new DownloadReceiver();
        }
        this.context.registerReceiver((BroadcastReceiver)this.downloadReceiver, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
    }

    public void unRegisterDownloadReceiver() {
        if (this.downloadReceiver != null) {
            this.context.unregisterReceiver((BroadcastReceiver)this.downloadReceiver);
        }
    }

    public void addProgressListener(ProgressListener progressListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(progressListener)) {
            this.listeners.add(progressListener);
        }
        if (this.downloadObserver == null && this.handler != null && this.downloadManager != null) {
            this.downloadObserver = new DownloadObserver(this.handler, this.downloadManager, this.mTaskId);
            this.context.getContentResolver().registerContentObserver(Uri.parse((String)"content://downloads/"), true, (ContentObserver)this.downloadObserver);
        }
    }

    public void removeProgressListener(ProgressListener progressListener) {
        if (!this.listeners.contains(progressListener)) {
            throw new NullPointerException("this progressListener not attch Updater");
        }
        if (this.listeners != null && !this.listeners.isEmpty()) {
            this.listeners.remove(progressListener);
            if (this.listeners.isEmpty() && this.downloadObserver != null) {
                this.context.getContentResolver().unregisterContentObserver((ContentObserver)this.downloadObserver);
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults, Object ... receivers) {
        EasyPermissions.onRequestPermissionsResult((int)requestCode, (String[])permissions, (int[])grantResults, (Object[])receivers);
    }

    public void onPermissionsGranted(int requestCode, List<String> perms) {
        this.download();
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (ProgressListener listener : this.listeners) {
                this.addProgressListener(listener);
            }
        }
    }

    public void onPermissionsDenied(int requestCode, List<String> perms) {
        this.download();
    }

    public static class Builder {
        private Updater mUpdater;

        public Builder(Activity context) {
            this.mUpdater = new Updater(context);
        }

        public Builder setApkName(String apkName) {
            this.mUpdater.apkName = apkName;
            return this;
        }

        public Builder setApkPath(String apkPath) {
            this.mUpdater.apkPath = apkPath;
            return this;
        }

        public Builder setApkDir(String dirName) {
            this.mUpdater.apkDirName = dirName;
            return this;
        }

        public Builder setDownloadUrl(String downloadUrl) {
            this.mUpdater.downloadUrl = downloadUrl;
            return this;
        }

        public Builder setNotificationTitle(String title) {
            this.mUpdater.title = title;
            return this;
        }

        public Builder hideNotification() {
            this.mUpdater.hideNotification = true;
            return this;
        }

        public Builder debug() {
            LogUtils.isDebug = true;
            return this;
        }

        public Builder allowedOverRoaming() {
            this.mUpdater.allowedOverRoaming = true;
            return this;
        }

        public Builder clearCache() {
            this.mUpdater.claerCache = true;
            return this;
        }

        public Updater start() {
            this.mUpdater.download();
            return this.mUpdater;
        }
    }
}

