/*
 * Decompiled with CFR 0.152.
 */
package com.simplepeng.updaterlibrary;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.content.FileProvider;
import com.simplepeng.updaterlibrary.LogUtils;
import java.io.File;

public class DownloadReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        Bundle bundle = intent.getExtras();
        long downId = bundle.getLong("extra_download_id", 0L);
        if (intent.getAction().equals("android.intent.action.DOWNLOAD_COMPLETE") || intent.getAction().equals("android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED")) {
            this.queryFileUri(context, downId);
        }
    }

    private void queryFileUri(Context context, long downloadApkId) {
        DownloadManager dManager = (DownloadManager)context.getSystemService("download");
        DownloadManager.Query query = new DownloadManager.Query();
        query.setFilterById(new long[]{downloadApkId});
        Cursor c = dManager.query(query);
        if (c != null) {
            int columnIndex;
            if (c.moveToFirst() && 8 == c.getInt(columnIndex = c.getColumnIndex("status"))) {
                String downloadFileUrl = c.getString(c.getColumnIndex("local_uri"));
                this.installApk(context, Uri.parse((String)downloadFileUrl));
            }
            c.close();
        }
    }

    private void installApk(Context context, Uri uri) {
        File file = new File(uri.getPath());
        if (!file.exists()) {
            LogUtils.debug("apk file not exists");
            return;
        }
        Intent intent = new Intent();
        if (Build.VERSION.SDK_INT >= 23) {
            Uri providerUri = FileProvider.getUriForFile((Context)context, (String)"com.simplepeng.updaterlibrary.fileprovider", (File)file);
            LogUtils.debug("providerUri==" + providerUri);
            intent.addFlags(1);
            intent.setDataAndType(providerUri, "application/vnd.android.package-archive");
        } else {
            intent.setDataAndType(uri, "application/vnd.android.package-archive");
        }
        intent.addFlags(0x10000000);
        intent.setAction("android.intent.action.VIEW");
        context.startActivity(intent);
    }
}

