/*
 * Decompiled with CFR 0.152.
 */
package com.simplecityapps.recyclerview_fastscroll.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.simplecityapps.recyclerview_fastscroll.R;
import com.simplecityapps.recyclerview_fastscroll.interfaces.OnFastScrollStateChangeListener;
import com.simplecityapps.recyclerview_fastscroll.utils.Utils;
import com.simplecityapps.recyclerview_fastscroll.views.FastScroller;

public class FastScrollRecyclerView
extends RecyclerView
implements RecyclerView.OnItemTouchListener {
    private static final String TAG = "FastScrollRecyclerView";
    private FastScroller mScrollbar;
    private boolean mFastScrollEnabled = true;
    private ScrollPositionState mScrollPosState = new ScrollPositionState();
    private int mDownX;
    private int mDownY;
    private int mLastY;
    private SparseIntArray mScrollOffsets;
    private ScrollOffsetInvalidator mScrollOffsetInvalidator;
    private OnFastScrollStateChangeListener mStateChangeListener;

    public FastScrollRecyclerView(Context context) {
        this(context, null);
    }

    public FastScrollRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FastScrollRecyclerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.FastScrollRecyclerView, 0, 0);
        try {
            this.mFastScrollEnabled = typedArray.getBoolean(R.styleable.FastScrollRecyclerView_fastScrollThumbEnabled, true);
        }
        finally {
            typedArray.recycle();
        }
        this.mScrollbar = new FastScroller(context, this, attrs);
        this.mScrollOffsetInvalidator = new ScrollOffsetInvalidator();
        this.mScrollOffsets = new SparseIntArray();
    }

    public int getScrollBarWidth() {
        return this.mScrollbar.getWidth();
    }

    public int getScrollBarThumbHeight() {
        return this.mScrollbar.getThumbHeight();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.addOnItemTouchListener(this);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (this.getAdapter() != null) {
            this.getAdapter().unregisterAdapterDataObserver((RecyclerView.AdapterDataObserver)this.mScrollOffsetInvalidator);
        }
        if (adapter != null) {
            adapter.registerAdapterDataObserver((RecyclerView.AdapterDataObserver)this.mScrollOffsetInvalidator);
        }
        super.setAdapter(adapter);
    }

    public boolean onInterceptTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent ev) {
        return this.handleTouchEvent(ev);
    }

    public void onTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent ev) {
        this.handleTouchEvent(ev);
    }

    private boolean handleTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        int x = (int)ev.getX();
        int y = (int)ev.getY();
        switch (action) {
            case 0: {
                this.mDownX = x;
                this.mDownY = this.mLastY = y;
                this.mScrollbar.handleTouchEvent(ev, this.mDownX, this.mDownY, this.mLastY, this.mStateChangeListener);
                break;
            }
            case 2: {
                this.mLastY = y;
                this.mScrollbar.handleTouchEvent(ev, this.mDownX, this.mDownY, this.mLastY, this.mStateChangeListener);
                break;
            }
            case 1: 
            case 3: {
                this.mScrollbar.handleTouchEvent(ev, this.mDownX, this.mDownY, this.mLastY, this.mStateChangeListener);
            }
        }
        return this.mScrollbar.isDragging();
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    protected int getAvailableScrollHeight(int adapterHeight, int yOffset) {
        int visibleHeight = this.getHeight();
        int scrollHeight = this.getPaddingTop() + yOffset + adapterHeight + this.getPaddingBottom();
        return scrollHeight - visibleHeight;
    }

    protected int getAvailableScrollBarHeight() {
        int visibleHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        return visibleHeight - this.mScrollbar.getThumbHeight();
    }

    public void draw(Canvas c) {
        super.draw(c);
        if (this.mFastScrollEnabled) {
            this.onUpdateScrollbar();
            this.mScrollbar.draw(c);
        }
    }

    protected void updateThumbPosition(ScrollPositionState scrollPosState, int rowCount) {
        int scrolledPastHeight;
        int availableScrollHeight;
        if (this.getAdapter() instanceof MeasurableAdapter) {
            availableScrollHeight = this.getAvailableScrollHeight(this.calculateAdapterHeight(), 0);
            scrolledPastHeight = this.calculateScrollDistanceToPosition(scrollPosState.rowIndex);
        } else {
            availableScrollHeight = this.getAvailableScrollHeight(rowCount * scrollPosState.rowHeight, 0);
            scrolledPastHeight = scrollPosState.rowIndex * scrollPosState.rowHeight;
        }
        int availableScrollBarHeight = this.getAvailableScrollBarHeight();
        if (availableScrollHeight <= 0) {
            this.mScrollbar.setThumbPosition(-1, -1);
            return;
        }
        int scrollY = Math.min(availableScrollHeight, this.getPaddingTop() + scrolledPastHeight);
        scrollY = this.isLayoutManagerReversed() ? scrollY + scrollPosState.rowTopOffset - availableScrollBarHeight : (scrollY -= scrollPosState.rowTopOffset);
        int scrollBarY = (int)((float)scrollY / (float)availableScrollHeight * (float)availableScrollBarHeight);
        scrollBarY = this.isLayoutManagerReversed() ? availableScrollBarHeight - scrollBarY + this.getPaddingBottom() : (scrollBarY += this.getPaddingTop());
        int scrollBarX = Utils.isRtl(this.getResources()) ? 0 : this.getWidth() - this.mScrollbar.getWidth();
        this.mScrollbar.setThumbPosition(scrollBarX, scrollBarY);
    }

    public String scrollToPositionAtProgress(float touchFraction) {
        int scrollOffset;
        int scrollPosition;
        float itemPos;
        int itemCount = this.getAdapter().getItemCount();
        if (itemCount == 0) {
            return "";
        }
        int spanCount = 1;
        int rowCount = itemCount;
        if (this.getLayoutManager() instanceof GridLayoutManager) {
            spanCount = ((GridLayoutManager)this.getLayoutManager()).getSpanCount();
            rowCount = (int)Math.ceil((double)rowCount / (double)spanCount);
        }
        this.stopScroll();
        this.getCurScrollState(this.mScrollPosState);
        if (this.getAdapter() instanceof MeasurableAdapter) {
            itemPos = this.findItemPosition(touchFraction);
            int availableScrollHeight = this.getAvailableScrollHeight(this.calculateAdapterHeight(), 0);
            int passedHeight = (int)((float)availableScrollHeight * touchFraction);
            scrollPosition = this.findMeasureAdapterFirstVisiblePosition(passedHeight);
            scrollOffset = this.calculateScrollDistanceToPosition(scrollPosition) - passedHeight;
        } else {
            itemPos = this.findItemPosition(touchFraction);
            int availableScrollHeight = this.getAvailableScrollHeight(rowCount * this.mScrollPosState.rowHeight, 0);
            int exactItemPos = (int)((float)availableScrollHeight * touchFraction);
            scrollPosition = spanCount * exactItemPos / this.mScrollPosState.rowHeight;
            scrollOffset = -(exactItemPos % this.mScrollPosState.rowHeight);
        }
        LinearLayoutManager layoutManager = (LinearLayoutManager)this.getLayoutManager();
        layoutManager.scrollToPositionWithOffset(scrollPosition, scrollOffset);
        if (!(this.getAdapter() instanceof SectionedAdapter)) {
            return "";
        }
        int posInt = (int)(touchFraction == 1.0f ? (float)(this.getAdapter().getItemCount() - 1) : itemPos);
        SectionedAdapter sectionedAdapter = (SectionedAdapter)this.getAdapter();
        return sectionedAdapter.getSectionName(posInt);
    }

    private int findMeasureAdapterFirstVisiblePosition(int passedHeight) {
        if (this.getAdapter() instanceof MeasurableAdapter) {
            MeasurableAdapter measurableAdapter = (MeasurableAdapter)this.getAdapter();
            for (int i = 0; i < this.getAdapter().getItemCount(); ++i) {
                int top = this.calculateScrollDistanceToPosition(i);
                int bottom = top + measurableAdapter.getViewTypeHeight(this, this.findViewHolderForAdapterPosition(i), this.getAdapter().getItemViewType(i));
                if (!(i == this.getAdapter().getItemCount() - 1 ? passedHeight >= top && passedHeight <= bottom : passedHeight >= top && passedHeight < bottom)) continue;
                return i;
            }
            int low = this.calculateScrollDistanceToPosition(0);
            int height = this.calculateScrollDistanceToPosition(this.getAdapter().getItemCount() - 1) + measurableAdapter.getViewTypeHeight(this, this.findViewHolderForAdapterPosition(this.getAdapter().getItemCount() - 1), this.getAdapter().getItemViewType(this.getAdapter().getItemCount() - 1));
            throw new IllegalStateException(String.format("Invalid passed height: %d, [low: %d, height: %d]", passedHeight, low, height));
        }
        throw new IllegalStateException("findMeasureAdapterFirstVisiblePosition() should only be called where the RecyclerView.Adapter is an instance of MeasurableAdapter");
    }

    private float findItemPosition(float touchFraction) {
        if (this.getAdapter() instanceof MeasurableAdapter) {
            MeasurableAdapter measurer = (MeasurableAdapter)this.getAdapter();
            int viewTop = (int)(touchFraction * (float)this.calculateAdapterHeight());
            for (int i = 0; i < this.getAdapter().getItemCount(); ++i) {
                int top = this.calculateScrollDistanceToPosition(i);
                int bottom = top + measurer.getViewTypeHeight(this, this.findViewHolderForAdapterPosition(i), this.getAdapter().getItemViewType(i));
                if (!(i == this.getAdapter().getItemCount() - 1 ? viewTop >= top && viewTop <= bottom : viewTop >= top && viewTop < bottom)) continue;
                return i;
            }
            Log.w((String)TAG, (String)("Failed to find a view at the provided scroll fraction (" + touchFraction + ")"));
            return touchFraction * (float)this.getAdapter().getItemCount();
        }
        return (float)this.getAdapter().getItemCount() * touchFraction;
    }

    public void onUpdateScrollbar() {
        if (this.getAdapter() == null) {
            return;
        }
        int rowCount = this.getAdapter().getItemCount();
        if (this.getLayoutManager() instanceof GridLayoutManager) {
            int spanCount = ((GridLayoutManager)this.getLayoutManager()).getSpanCount();
            rowCount = (int)Math.ceil((double)rowCount / (double)spanCount);
        }
        if (rowCount == 0) {
            this.mScrollbar.setThumbPosition(-1, -1);
            return;
        }
        this.getCurScrollState(this.mScrollPosState);
        if (this.mScrollPosState.rowIndex < 0) {
            this.mScrollbar.setThumbPosition(-1, -1);
            return;
        }
        this.updateThumbPosition(this.mScrollPosState, rowCount);
    }

    protected boolean isLayoutManagerReversed() {
        if (this.getLayoutManager() instanceof LinearLayoutManager) {
            return ((LinearLayoutManager)this.getLayoutManager()).getReverseLayout();
        }
        return false;
    }

    private void getCurScrollState(ScrollPositionState stateOut) {
        stateOut.rowIndex = -1;
        stateOut.rowTopOffset = -1;
        stateOut.rowHeight = -1;
        int itemCount = this.getAdapter().getItemCount();
        if (itemCount == 0 || this.getChildCount() == 0) {
            return;
        }
        View child = this.getChildAt(0);
        stateOut.rowIndex = this.getChildAdapterPosition(child);
        if (this.getLayoutManager() instanceof GridLayoutManager) {
            stateOut.rowIndex /= ((GridLayoutManager)this.getLayoutManager()).getSpanCount();
        }
        if (this.getAdapter() instanceof MeasurableAdapter) {
            stateOut.rowTopOffset = this.getLayoutManager().getDecoratedTop(child);
            stateOut.rowHeight = ((MeasurableAdapter)this.getAdapter()).getViewTypeHeight(this, this.findViewHolderForAdapterPosition(stateOut.rowIndex), this.getAdapter().getItemViewType(stateOut.rowIndex));
        } else {
            stateOut.rowTopOffset = this.getLayoutManager().getDecoratedTop(child);
            stateOut.rowHeight = child.getHeight() + this.getLayoutManager().getTopDecorationHeight(child) + this.getLayoutManager().getBottomDecorationHeight(child);
        }
    }

    private int calculateScrollDistanceToPosition(int adapterIndex) {
        if (!(this.getAdapter() instanceof MeasurableAdapter)) {
            throw new IllegalStateException("calculateScrollDistanceToPosition() should only be called where the RecyclerView.Adapter is an instance of MeasurableAdapter");
        }
        if (this.mScrollOffsets.indexOfKey(adapterIndex) >= 0) {
            return this.mScrollOffsets.get(adapterIndex);
        }
        int totalHeight = 0;
        MeasurableAdapter measurer = (MeasurableAdapter)this.getAdapter();
        for (int i = 0; i < adapterIndex; ++i) {
            this.mScrollOffsets.put(i, totalHeight);
            int viewType = this.getAdapter().getItemViewType(i);
            totalHeight += measurer.getViewTypeHeight(this, this.findViewHolderForAdapterPosition(i), viewType);
        }
        this.mScrollOffsets.put(adapterIndex, totalHeight);
        return totalHeight;
    }

    private int calculateAdapterHeight() {
        if (!(this.getAdapter() instanceof MeasurableAdapter)) {
            throw new IllegalStateException("calculateAdapterHeight() should only be called where the RecyclerView.Adapter is an instance of MeasurableAdapter");
        }
        return this.calculateScrollDistanceToPosition(this.getAdapter().getItemCount());
    }

    public void showScrollbar() {
        this.mScrollbar.show();
    }

    public void setThumbColor(@ColorInt int color) {
        this.mScrollbar.setThumbColor(color);
    }

    public void setTrackColor(@ColorInt int color) {
        this.mScrollbar.setTrackColor(color);
    }

    public void setPopupBgColor(@ColorInt int color) {
        this.mScrollbar.setPopupBgColor(color);
    }

    public void setPopupTextColor(@ColorInt int color) {
        this.mScrollbar.setPopupTextColor(color);
    }

    public void setPopupTextSize(int textSize) {
        this.mScrollbar.setPopupTextSize(textSize);
    }

    public void setPopUpTypeface(Typeface typeface) {
        this.mScrollbar.setPopupTypeface(typeface);
    }

    public void setAutoHideDelay(int hideDelay) {
        this.mScrollbar.setAutoHideDelay(hideDelay);
    }

    public void setAutoHideEnabled(boolean autoHideEnabled) {
        this.mScrollbar.setAutoHideEnabled(autoHideEnabled);
    }

    public void setOnFastScrollStateChangeListener(OnFastScrollStateChangeListener stateChangeListener) {
        this.mStateChangeListener = stateChangeListener;
    }

    @Deprecated
    public void setStateChangeListener(OnFastScrollStateChangeListener stateChangeListener) {
        this.setOnFastScrollStateChangeListener(stateChangeListener);
    }

    public void setThumbInactiveColor(@ColorInt int color) {
        this.mScrollbar.setThumbInactiveColor(color);
    }

    public void allowThumbInactiveColor(boolean allowInactiveColor) {
        this.mScrollbar.enableThumbInactiveColor(allowInactiveColor);
    }

    @Deprecated
    public void setThumbInactiveColor(boolean allowInactiveColor) {
        this.allowThumbInactiveColor(allowInactiveColor);
    }

    public void setFastScrollEnabled(boolean fastScrollEnabled) {
        this.mFastScrollEnabled = fastScrollEnabled;
    }

    @Deprecated
    public void setThumbEnabled(boolean thumbEnabled) {
        this.setFastScrollEnabled(thumbEnabled);
    }

    public void setPopupPosition(@FastScroller.PopupPosition int popupPosition) {
        this.mScrollbar.setPopupPosition(popupPosition);
    }

    public static interface MeasurableAdapter<VH extends RecyclerView.ViewHolder> {
        public int getViewTypeHeight(RecyclerView var1, @Nullable VH var2, int var3);
    }

    public static interface SectionedAdapter {
        @NonNull
        public String getSectionName(int var1);
    }

    private class ScrollOffsetInvalidator
    extends RecyclerView.AdapterDataObserver {
        private ScrollOffsetInvalidator() {
        }

        private void invalidateAllScrollOffsets() {
            FastScrollRecyclerView.this.mScrollOffsets.clear();
        }

        public void onChanged() {
            this.invalidateAllScrollOffsets();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            this.invalidateAllScrollOffsets();
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            this.invalidateAllScrollOffsets();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            this.invalidateAllScrollOffsets();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            this.invalidateAllScrollOffsets();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            this.invalidateAllScrollOffsets();
        }
    }

    public static class ScrollPositionState {
        int rowIndex;
        int rowTopOffset;
        int rowHeight;
    }
}

