/*
 * Decompiled with CFR 0.152.
 */
package com.simplecityapps.recyclerview_fastscroll.views;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.v4.view.animation.FastOutLinearInInterpolator;
import android.support.v4.view.animation.LinearOutSlowInInterpolator;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.simplecityapps.recyclerview_fastscroll.R;
import com.simplecityapps.recyclerview_fastscroll.interfaces.OnFastScrollStateChangeListener;
import com.simplecityapps.recyclerview_fastscroll.utils.Utils;
import com.simplecityapps.recyclerview_fastscroll.views.FastScrollPopup;
import com.simplecityapps.recyclerview_fastscroll.views.FastScrollRecyclerView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class FastScroller {
    private static final int DEFAULT_AUTO_HIDE_DELAY = 1500;
    private FastScrollRecyclerView mRecyclerView;
    private FastScrollPopup mPopup;
    private int mThumbHeight;
    private int mWidth;
    private Paint mThumb;
    private Paint mTrack;
    private Rect mTmpRect = new Rect();
    private Rect mInvalidateRect = new Rect();
    private Rect mInvalidateTmpRect = new Rect();
    private int mTouchInset;
    private int mTouchOffset;
    public Point mThumbPosition = new Point(-1, -1);
    public Point mOffset = new Point(0, 0);
    private boolean mIsDragging;
    private Animator mAutoHideAnimator;
    boolean mAnimatingShow;
    private int mAutoHideDelay = 1500;
    private boolean mAutoHideEnabled = true;
    private final Runnable mHideRunnable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FastScroller(Context context, FastScrollRecyclerView recyclerView, AttributeSet attrs) {
        Resources resources = context.getResources();
        this.mRecyclerView = recyclerView;
        this.mPopup = new FastScrollPopup(resources, recyclerView);
        this.mThumbHeight = Utils.toPixels(resources, 48.0f);
        this.mWidth = Utils.toPixels(resources, 8.0f);
        this.mTouchInset = Utils.toPixels(resources, -24.0f);
        this.mThumb = new Paint(1);
        this.mTrack = new Paint(1);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.FastScrollRecyclerView, 0, 0);
        try {
            this.mAutoHideEnabled = typedArray.getBoolean(R.styleable.FastScrollRecyclerView_fastScrollAutoHide, true);
            this.mAutoHideDelay = typedArray.getInteger(R.styleable.FastScrollRecyclerView_fastScrollAutoHideDelay, 1500);
            int trackColor = typedArray.getColor(R.styleable.FastScrollRecyclerView_fastScrollTrackColor, 0x1F000000);
            int thumbColor = typedArray.getColor(R.styleable.FastScrollRecyclerView_fastScrollThumbColor, -16777216);
            int popupBgColor = typedArray.getColor(R.styleable.FastScrollRecyclerView_fastScrollPopupBgColor, -16777216);
            int popupTextColor = typedArray.getColor(R.styleable.FastScrollRecyclerView_fastScrollPopupTextColor, -1);
            int popupTextSize = typedArray.getDimensionPixelSize(R.styleable.FastScrollRecyclerView_fastScrollPopupTextSize, Utils.toScreenPixels(resources, 56.0f));
            int popupBackgroundSize = typedArray.getDimensionPixelSize(R.styleable.FastScrollRecyclerView_fastScrollPopupBackgroundSize, Utils.toPixels(resources, 88.0f));
            int popupPosition = typedArray.getInteger(R.styleable.FastScrollRecyclerView_fastScrollPopupPosition, 0);
            this.mTrack.setColor(trackColor);
            this.mThumb.setColor(thumbColor);
            this.mPopup.setBgColor(popupBgColor);
            this.mPopup.setTextColor(popupTextColor);
            this.mPopup.setTextSize(popupTextSize);
            this.mPopup.setBackgroundSize(popupBackgroundSize);
            this.mPopup.setPopupPosition(popupPosition);
        }
        finally {
            typedArray.recycle();
        }
        this.mHideRunnable = new Runnable(){

            @Override
            public void run() {
                if (!FastScroller.this.mIsDragging) {
                    if (FastScroller.this.mAutoHideAnimator != null) {
                        FastScroller.this.mAutoHideAnimator.cancel();
                    }
                    FastScroller.this.mAutoHideAnimator = (Animator)ObjectAnimator.ofInt((Object)FastScroller.this, (String)"offsetX", (int[])new int[]{(Utils.isRtl(FastScroller.this.mRecyclerView.getResources()) ? -1 : 1) * FastScroller.this.mWidth});
                    FastScroller.this.mAutoHideAnimator.setInterpolator((TimeInterpolator)new FastOutLinearInInterpolator());
                    FastScroller.this.mAutoHideAnimator.setDuration(200L);
                    FastScroller.this.mAutoHideAnimator.start();
                }
            }
        };
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                FastScroller.this.show();
            }
        });
        if (this.mAutoHideEnabled) {
            this.postAutoHideDelayed();
        }
    }

    public int getThumbHeight() {
        return this.mThumbHeight;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public boolean isDragging() {
        return this.mIsDragging;
    }

    public void handleTouchEvent(MotionEvent ev, int downX, int downY, int lastY, OnFastScrollStateChangeListener stateChangeListener) {
        ViewConfiguration config = ViewConfiguration.get((Context)this.mRecyclerView.getContext());
        int action = ev.getAction();
        int y = (int)ev.getY();
        switch (action) {
            case 0: {
                if (!this.isNearPoint(downX, downY)) break;
                this.mTouchOffset = downY - this.mThumbPosition.y;
                break;
            }
            case 2: {
                if (!this.mIsDragging && this.isNearPoint(downX, downY) && Math.abs(y - downY) > config.getScaledTouchSlop()) {
                    this.mRecyclerView.getParent().requestDisallowInterceptTouchEvent(true);
                    this.mIsDragging = true;
                    this.mTouchOffset += lastY - downY;
                    this.mPopup.animateVisibility(true);
                    if (stateChangeListener != null) {
                        stateChangeListener.onFastScrollStart();
                    }
                }
                if (!this.mIsDragging) break;
                int top = 0;
                int bottom = this.mRecyclerView.getHeight() - this.mThumbHeight;
                float boundedY = Math.max(top, Math.min(bottom, y - this.mTouchOffset));
                String sectionName = this.mRecyclerView.scrollToPositionAtProgress((boundedY - (float)top) / (float)(bottom - top));
                this.mPopup.setSectionName(sectionName);
                this.mPopup.animateVisibility(!sectionName.isEmpty());
                this.mRecyclerView.invalidate(this.mPopup.updateFastScrollerBounds(this.mRecyclerView, this.mThumbPosition.y));
                break;
            }
            case 1: 
            case 3: {
                this.mTouchOffset = 0;
                if (!this.mIsDragging) break;
                this.mIsDragging = false;
                this.mPopup.animateVisibility(false);
                if (stateChangeListener == null) break;
                stateChangeListener.onFastScrollStop();
            }
        }
    }

    public void draw(Canvas canvas) {
        if (this.mThumbPosition.x < 0 || this.mThumbPosition.y < 0) {
            return;
        }
        canvas.drawRect((float)(this.mThumbPosition.x + this.mOffset.x), (float)(this.mThumbHeight / 2 + this.mOffset.y), (float)(this.mThumbPosition.x + this.mOffset.x + this.mWidth), (float)(this.mRecyclerView.getHeight() + this.mOffset.y - this.mThumbHeight / 2), this.mTrack);
        canvas.drawRect((float)(this.mThumbPosition.x + this.mOffset.x), (float)(this.mThumbPosition.y + this.mOffset.y), (float)(this.mThumbPosition.x + this.mOffset.x + this.mWidth), (float)(this.mThumbPosition.y + this.mOffset.y + this.mThumbHeight), this.mThumb);
        this.mPopup.draw(canvas);
    }

    private boolean isNearPoint(int x, int y) {
        this.mTmpRect.set(this.mThumbPosition.x, this.mThumbPosition.y, this.mThumbPosition.x + this.mWidth, this.mThumbPosition.y + this.mThumbHeight);
        this.mTmpRect.inset(this.mTouchInset, this.mTouchInset);
        return this.mTmpRect.contains(x, y);
    }

    public void setThumbPosition(int x, int y) {
        if (this.mThumbPosition.x == x && this.mThumbPosition.y == y) {
            return;
        }
        this.mInvalidateRect.set(this.mThumbPosition.x + this.mOffset.x, this.mOffset.y, this.mThumbPosition.x + this.mOffset.x + this.mWidth, this.mRecyclerView.getHeight() + this.mOffset.y);
        this.mThumbPosition.set(x, y);
        this.mInvalidateTmpRect.set(this.mThumbPosition.x + this.mOffset.x, this.mOffset.y, this.mThumbPosition.x + this.mOffset.x + this.mWidth, this.mRecyclerView.getHeight() + this.mOffset.y);
        this.mInvalidateRect.union(this.mInvalidateTmpRect);
        this.mRecyclerView.invalidate(this.mInvalidateRect);
    }

    public void setOffset(int x, int y) {
        if (this.mOffset.x == x && this.mOffset.y == y) {
            return;
        }
        this.mInvalidateRect.set(this.mThumbPosition.x + this.mOffset.x, this.mOffset.y, this.mThumbPosition.x + this.mOffset.x + this.mWidth, this.mRecyclerView.getHeight() + this.mOffset.y);
        this.mOffset.set(x, y);
        this.mInvalidateTmpRect.set(this.mThumbPosition.x + this.mOffset.x, this.mOffset.y, this.mThumbPosition.x + this.mOffset.x + this.mWidth, this.mRecyclerView.getHeight() + this.mOffset.y);
        this.mInvalidateRect.union(this.mInvalidateTmpRect);
        this.mRecyclerView.invalidate(this.mInvalidateRect);
    }

    @Keep
    public void setOffsetX(int x) {
        this.setOffset(x, this.mOffset.y);
    }

    @Keep
    public int getOffsetX() {
        return this.mOffset.x;
    }

    public void show() {
        if (!this.mAnimatingShow) {
            if (this.mAutoHideAnimator != null) {
                this.mAutoHideAnimator.cancel();
            }
            this.mAutoHideAnimator = ObjectAnimator.ofInt((Object)this, (String)"offsetX", (int[])new int[]{0});
            this.mAutoHideAnimator.setInterpolator((TimeInterpolator)new LinearOutSlowInInterpolator());
            this.mAutoHideAnimator.setDuration(150L);
            this.mAutoHideAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationCancel(Animator animation) {
                    super.onAnimationCancel(animation);
                    FastScroller.this.mAnimatingShow = false;
                }

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    FastScroller.this.mAnimatingShow = false;
                }
            });
            this.mAnimatingShow = true;
            this.mAutoHideAnimator.start();
        }
        if (this.mAutoHideEnabled) {
            this.postAutoHideDelayed();
        } else {
            this.cancelAutoHide();
        }
    }

    protected void postAutoHideDelayed() {
        if (this.mRecyclerView != null) {
            this.cancelAutoHide();
            this.mRecyclerView.postDelayed(this.mHideRunnable, this.mAutoHideDelay);
        }
    }

    protected void cancelAutoHide() {
        if (this.mRecyclerView != null) {
            this.mRecyclerView.removeCallbacks(this.mHideRunnable);
        }
    }

    public void setThumbColor(@ColorInt int color) {
        this.mThumb.setColor(color);
        this.mRecyclerView.invalidate(this.mInvalidateRect);
    }

    public void setTrackColor(@ColorInt int color) {
        this.mTrack.setColor(color);
        this.mRecyclerView.invalidate(this.mInvalidateRect);
    }

    public void setPopupBgColor(@ColorInt int color) {
        this.mPopup.setBgColor(color);
    }

    public void setPopupTextColor(@ColorInt int color) {
        this.mPopup.setTextColor(color);
    }

    public void setPopupTypeface(Typeface typeface) {
        this.mPopup.setTypeface(typeface);
    }

    public void setPopupTextSize(int size) {
        this.mPopup.setTextSize(size);
    }

    public void setAutoHideDelay(int hideDelay) {
        this.mAutoHideDelay = hideDelay;
        if (this.mAutoHideEnabled) {
            this.postAutoHideDelayed();
        }
    }

    public void setAutoHideEnabled(boolean autoHideEnabled) {
        this.mAutoHideEnabled = autoHideEnabled;
        if (autoHideEnabled) {
            this.postAutoHideDelayed();
        } else {
            this.cancelAutoHide();
        }
    }

    public void setPopupPosition(int popupPosition) {
        this.mPopup.setPopupPosition(popupPosition);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FastScrollerPopupPosition {
        public static final int ADJACENT = 0;
        public static final int CENTER = 1;
    }
}

