/*
 * Decompiled with CFR 0.152.
 */
package com.simplecityapps.recyclerview_fastscroll.views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.simplecityapps.recyclerview_fastscroll.interfaces.OnFastScrollStateChangeListener;
import com.simplecityapps.recyclerview_fastscroll.utils.Utils;
import com.simplecityapps.recyclerview_fastscroll.views.FastScroller;

public class FastScrollRecyclerView
extends RecyclerView
implements RecyclerView.OnItemTouchListener {
    private FastScroller mScrollbar;
    private ScrollPositionState mScrollPosState = new ScrollPositionState();
    private int mDownX;
    private int mDownY;
    private int mLastY;
    private OnFastScrollStateChangeListener mStateChangeListener;

    public FastScrollRecyclerView(Context context) {
        this(context, null);
    }

    public FastScrollRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FastScrollRecyclerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mScrollbar = new FastScroller(context, this, attrs);
    }

    public int getScrollBarWidth() {
        return this.mScrollbar.getWidth();
    }

    public int getScrollBarThumbHeight() {
        return this.mScrollbar.getThumbHeight();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.addOnItemTouchListener(this);
    }

    public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent ev) {
        return this.handleTouchEvent(ev);
    }

    public void onTouchEvent(RecyclerView rv, MotionEvent ev) {
        this.handleTouchEvent(ev);
    }

    private boolean handleTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        int x = (int)ev.getX();
        int y = (int)ev.getY();
        switch (action) {
            case 0: {
                this.mDownX = x;
                this.mDownY = this.mLastY = y;
                this.mScrollbar.handleTouchEvent(ev, this.mDownX, this.mDownY, this.mLastY, this.mStateChangeListener);
                break;
            }
            case 2: {
                this.mLastY = y;
                this.mScrollbar.handleTouchEvent(ev, this.mDownX, this.mDownY, this.mLastY, this.mStateChangeListener);
                break;
            }
            case 1: 
            case 3: {
                this.mScrollbar.handleTouchEvent(ev, this.mDownX, this.mDownY, this.mLastY, this.mStateChangeListener);
            }
        }
        return this.mScrollbar.isDragging();
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    protected int getAvailableScrollHeight(int rowCount, int rowHeight, int yOffset) {
        int visibleHeight = this.getHeight();
        int scrollHeight = this.getPaddingTop() + yOffset + rowCount * rowHeight + this.getPaddingBottom();
        int availableScrollHeight = scrollHeight - visibleHeight;
        return availableScrollHeight;
    }

    protected int getAvailableScrollBarHeight() {
        int visibleHeight = this.getHeight();
        int availableScrollBarHeight = visibleHeight - this.mScrollbar.getThumbHeight();
        return availableScrollBarHeight;
    }

    public void draw(Canvas c) {
        super.draw(c);
        this.onUpdateScrollbar();
        this.mScrollbar.draw(c);
    }

    protected void synchronizeScrollBarThumbOffsetToViewScroll(ScrollPositionState scrollPosState, int rowCount, int yOffset) {
        int availableScrollHeight = this.getAvailableScrollHeight(rowCount, scrollPosState.rowHeight, yOffset);
        int availableScrollBarHeight = this.getAvailableScrollBarHeight();
        if (availableScrollHeight <= 0) {
            this.mScrollbar.setThumbPosition(-1, -1);
            return;
        }
        int scrollY = this.getPaddingTop() + yOffset + scrollPosState.rowIndex * scrollPosState.rowHeight - scrollPosState.rowTopOffset;
        int scrollBarY = (int)((float)scrollY / (float)availableScrollHeight * (float)availableScrollBarHeight);
        int scrollBarX = Utils.isRtl(this.getResources()) ? 0 : this.getWidth() - this.mScrollbar.getWidth();
        this.mScrollbar.setThumbPosition(scrollBarX, scrollBarY);
    }

    public String scrollToPositionAtProgress(float touchFraction) {
        int itemCount = this.getAdapter().getItemCount();
        if (itemCount == 0) {
            return "";
        }
        int spanCount = 1;
        int rowCount = itemCount;
        if (this.getLayoutManager() instanceof GridLayoutManager) {
            spanCount = ((GridLayoutManager)this.getLayoutManager()).getSpanCount();
            rowCount = (int)Math.ceil((double)rowCount / (double)spanCount);
        }
        this.stopScroll();
        this.getCurScrollState(this.mScrollPosState);
        float itemPos = (float)itemCount * touchFraction;
        int availableScrollHeight = this.getAvailableScrollHeight(rowCount, this.mScrollPosState.rowHeight, 0);
        int exactItemPos = (int)((float)availableScrollHeight * touchFraction);
        LinearLayoutManager layoutManager = (LinearLayoutManager)this.getLayoutManager();
        layoutManager.scrollToPositionWithOffset(spanCount * exactItemPos / this.mScrollPosState.rowHeight, -(exactItemPos % this.mScrollPosState.rowHeight));
        if (!(this.getAdapter() instanceof SectionedAdapter)) {
            return "";
        }
        int posInt = (int)(touchFraction == 1.0f ? itemPos - 1.0f : itemPos);
        SectionedAdapter sectionedAdapter = (SectionedAdapter)this.getAdapter();
        return sectionedAdapter.getSectionName(posInt);
    }

    public void onUpdateScrollbar() {
        if (this.getAdapter() == null) {
            return;
        }
        int rowCount = this.getAdapter().getItemCount();
        if (this.getLayoutManager() instanceof GridLayoutManager) {
            int spanCount = ((GridLayoutManager)this.getLayoutManager()).getSpanCount();
            rowCount = (int)Math.ceil((double)rowCount / (double)spanCount);
        }
        if (rowCount == 0) {
            this.mScrollbar.setThumbPosition(-1, -1);
            return;
        }
        this.getCurScrollState(this.mScrollPosState);
        if (this.mScrollPosState.rowIndex < 0) {
            this.mScrollbar.setThumbPosition(-1, -1);
            return;
        }
        this.synchronizeScrollBarThumbOffsetToViewScroll(this.mScrollPosState, rowCount, 0);
    }

    private void getCurScrollState(ScrollPositionState stateOut) {
        stateOut.rowIndex = -1;
        stateOut.rowTopOffset = -1;
        stateOut.rowHeight = -1;
        int itemCount = this.getAdapter().getItemCount();
        if (itemCount == 0 || this.getChildCount() == 0) {
            return;
        }
        View child = this.getChildAt(0);
        stateOut.rowIndex = this.getChildAdapterPosition(child);
        if (this.getLayoutManager() instanceof GridLayoutManager) {
            stateOut.rowIndex /= ((GridLayoutManager)this.getLayoutManager()).getSpanCount();
        }
        stateOut.rowTopOffset = this.getLayoutManager().getDecoratedTop(child);
        stateOut.rowHeight = child.getHeight() + this.getLayoutManager().getTopDecorationHeight(child) + this.getLayoutManager().getBottomDecorationHeight(child);
    }

    public void setThumbColor(@ColorInt int color) {
        this.mScrollbar.setThumbColor(color);
    }

    public void setTrackColor(@ColorInt int color) {
        this.mScrollbar.setTrackColor(color);
    }

    public void setPopupBgColor(@ColorInt int color) {
        this.mScrollbar.setPopupBgColor(color);
    }

    public void setPopupTextColor(@ColorInt int color) {
        this.mScrollbar.setPopupTextColor(color);
    }

    public void setPopupTextSize(int textSize) {
        this.mScrollbar.setPopupTextSize(textSize);
    }

    public void setPopUpTypeface(Typeface typeface) {
        this.mScrollbar.setPopupTypeface(typeface);
    }

    public void setAutoHideDelay(int hideDelay) {
        this.mScrollbar.setAutoHideDelay(hideDelay);
    }

    public void setAutoHideEnabled(boolean autoHideEnabled) {
        this.mScrollbar.setAutoHideEnabled(autoHideEnabled);
    }

    public void setStateChangeListener(OnFastScrollStateChangeListener stateChangeListener) {
        this.mStateChangeListener = stateChangeListener;
    }

    public void setPopupPosition(int popupPosition) {
        this.mScrollbar.setPopupPosition(popupPosition);
    }

    public static interface SectionedAdapter {
        @NonNull
        public String getSectionName(int var1);
    }

    public static class ScrollPositionState {
        public int rowIndex;
        public int rowTopOffset;
        public int rowHeight;
    }
}

