/*
 * Decompiled with CFR 0.152.
 */
package com.simple.spiderman;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.io.Serializable;

public class CrashModel
implements Parcelable {
    private Throwable ex;
    private String packageName;
    private String exceptionMsg;
    private String className;
    private String fileName;
    private String methodName;
    private int lineNumber;
    private String exceptionType;
    private String fullException;
    private long time;
    private Device device = new Device();
    private String versionCode;
    private String versionName;
    public static final Parcelable.Creator<CrashModel> CREATOR = new Parcelable.Creator<CrashModel>(){

        public CrashModel createFromParcel(Parcel in) {
            return new CrashModel(in);
        }

        public CrashModel[] newArray(int size) {
            return new CrashModel[size];
        }
    };

    protected CrashModel(Parcel in) {
        this.ex = (Throwable)in.readSerializable();
        this.exceptionMsg = in.readString();
        this.className = in.readString();
        this.fileName = in.readString();
        this.methodName = in.readString();
        this.lineNumber = in.readInt();
        this.exceptionType = in.readString();
        this.fullException = in.readString();
        this.time = in.readLong();
        this.versionCode = in.readString();
        this.versionName = in.readString();
    }

    public CrashModel() {
    }

    public Throwable getEx() {
        return this.ex;
    }

    public void setEx(Throwable ex) {
        this.ex = ex;
    }

    public String getExceptionMsg() {
        return this.exceptionMsg;
    }

    public void setExceptionMsg(String exceptionMsg) {
        this.exceptionMsg = exceptionMsg;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getFileName() {
        return TextUtils.isEmpty((CharSequence)this.fileName) ? this.className : this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public void setExceptionType(String exceptionType) {
        this.exceptionType = exceptionType;
    }

    public String getFullException() {
        return this.fullException;
    }

    public void setFullException(String fullException) {
        this.fullException = fullException;
    }

    public String getPackageName() {
        return this.getClassName().replace(this.getFileName(), "");
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public Device getDevice() {
        return this.device;
    }

    public String getVersionCode() {
        return this.versionCode;
    }

    public void setVersionCode(String versionCode) {
        this.versionCode = versionCode;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this.ex);
        dest.writeString(this.exceptionMsg);
        dest.writeString(this.className);
        dest.writeString(this.fileName);
        dest.writeString(this.methodName);
        dest.writeInt(this.lineNumber);
        dest.writeString(this.exceptionType);
        dest.writeString(this.fullException);
        dest.writeLong(this.time);
        dest.writeString(this.versionCode);
        dest.writeString(this.versionName);
    }

    public static class Device
    implements Parcelable {
        private String model = Build.MODEL;
        private String brand = Build.BRAND;
        private String version = String.valueOf(Build.VERSION.SDK_INT);
        private String release = Build.VERSION.RELEASE;
        private String cpuAbi = Build.CPU_ABI;
        public static final Parcelable.Creator<Device> CREATOR = new Parcelable.Creator<Device>(){

            public Device createFromParcel(Parcel in) {
                return new Device(in);
            }

            public Device[] newArray(int size) {
                return new Device[size];
            }
        };

        public Device() {
        }

        protected Device(Parcel in) {
            this.model = in.readString();
            this.brand = in.readString();
            this.version = in.readString();
            this.release = in.readString();
            this.cpuAbi = in.readString();
        }

        public String getModel() {
            return this.model;
        }

        public String getBrand() {
            return this.brand;
        }

        public String getVersion() {
            return this.version;
        }

        public String getRelease() {
            return this.release;
        }

        public String getCpuAbi() {
            return this.cpuAbi;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.model);
            dest.writeString(this.brand);
            dest.writeString(this.version);
            dest.writeString(this.release);
            dest.writeString(this.cpuAbi);
        }
    }
}

