/*
 * Decompiled with CFR 0.152.
 */
package com.simple.spiderman;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.os.Process;
import android.support.annotation.StyleRes;
import com.simple.spiderman.CrashActivity;
import com.simple.spiderman.CrashModel;
import com.simple.spiderman.R;
import com.simple.spiderman.Utils;

public class SpiderMan
implements Thread.UncaughtExceptionHandler {
    public static final String TAG = "SpiderMan";
    private static SpiderMan spiderMan;
    private static Context mContext;
    public static int mThemeId;

    private SpiderMan() {
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    public static SpiderMan init(Context context) {
        mContext = context;
        spiderMan = new SpiderMan();
        return spiderMan;
    }

    @Override
    public void uncaughtException(Thread t, Throwable ex) {
        CrashModel model = Utils.parseCrash(ex);
        SpiderMan.handleException(model);
        Process.killProcess((int)Process.myPid());
    }

    public void setTheme(@StyleRes int themeId) {
        mThemeId = themeId;
    }

    private static void handleException(CrashModel model) {
        Intent intent = new Intent(SpiderMan.getContext(), CrashActivity.class);
        intent.putExtra("crash_model", (Parcelable)model);
        intent.setFlags(0x10000000);
        mContext.startActivity(intent);
    }

    public static void show(Throwable e) {
        CrashModel model = Utils.parseCrash(e);
        SpiderMan.handleException(model);
    }

    public static Context getContext() {
        if (mContext == null) {
            throw new NullPointerException("Please call init method in Application onCreate");
        }
        return mContext;
    }

    static {
        mThemeId = R.style.SpiderManTheme_Light;
    }
}

