/*
 * Decompiled with CFR 0.152.
 */
package com.simple.spiderman;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.FileProvider;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupMenu;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import com.simple.spiderman.CrashModel;
import com.simple.spiderman.R;
import com.simple.spiderman.SpiderMan;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;

public class CrashActivity
extends AppCompatActivity {
    public static final String CRASH_MODEL = "crash_model";
    @SuppressLint(value={"SimpleDateFormat"})
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private CrashModel model;
    private ViewGroup root;
    private ScrollView scrollView;
    private ViewGroup toolbar;
    private static final int REQUEST_CODE = 110;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(SpiderMan.mThemeId);
        this.setContentView(R.layout.activity_crash);
        this.model = (CrashModel)this.getIntent().getParcelableExtra(CRASH_MODEL);
        if (this.model == null) {
            return;
        }
        Log.e((String)"SpiderMan", (String)Log.getStackTraceString((Throwable)this.model.getEx()));
        this.root = (ViewGroup)this.findViewById(R.id.root);
        this.scrollView = (ScrollView)this.findViewById(R.id.scrollView);
        this.toolbar = (ViewGroup)this.findViewById(R.id.toolbar);
        TextView textMessage = (TextView)this.findViewById(R.id.textMessage);
        TextView tv_className = (TextView)this.findViewById(R.id.tv_className);
        TextView tv_methodName = (TextView)this.findViewById(R.id.tv_methodName);
        TextView tv_lineNumber = (TextView)this.findViewById(R.id.tv_lineNumber);
        TextView tv_exceptionType = (TextView)this.findViewById(R.id.tv_exceptionType);
        TextView tv_fullException = (TextView)this.findViewById(R.id.tv_fullException);
        TextView tv_time = (TextView)this.findViewById(R.id.tv_time);
        TextView tv_model = (TextView)this.findViewById(R.id.tv_model);
        TextView tv_brand = (TextView)this.findViewById(R.id.tv_brand);
        TextView tv_version = (TextView)this.findViewById(R.id.tv_version);
        TextView tv_more = (TextView)this.findViewById(R.id.tv_more);
        textMessage.setText((CharSequence)this.model.getExceptionMsg());
        tv_className.setText((CharSequence)this.model.getFileName());
        tv_methodName.setText((CharSequence)this.model.getMethodName());
        tv_lineNumber.setText((CharSequence)String.valueOf(this.model.getLineNumber()));
        tv_exceptionType.setText((CharSequence)this.model.getExceptionType());
        tv_fullException.setText((CharSequence)this.model.getFullException());
        tv_time.setText((CharSequence)this.df.format(this.model.getTime()));
        tv_model.setText((CharSequence)this.model.getDevice().getModel());
        tv_brand.setText((CharSequence)this.model.getDevice().getBrand());
        tv_version.setText((CharSequence)this.model.getDevice().getVersion());
        tv_more.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PopupMenu menu2 = new PopupMenu((Context)CrashActivity.this, v);
                menu2.inflate(R.menu.menu_more);
                menu2.show();
                menu2.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener(){

                    public boolean onMenuItemClick(MenuItem item) {
                        int id2 = item.getItemId();
                        if (id2 == R.id.menu_copy_text) {
                            String crashText = CrashActivity.this.getShareText(CrashActivity.this.model);
                            ClipboardManager cm = (ClipboardManager)CrashActivity.this.getSystemService("clipboard");
                            if (cm != null) {
                                ClipData mClipData = ClipData.newPlainText((CharSequence)"crash", (CharSequence)crashText);
                                cm.setPrimaryClip(mClipData);
                                CrashActivity.this.showToast(CrashActivity.this.getString(R.string.simpleCopied));
                            }
                        } else if (id2 == R.id.menu_share_text) {
                            String crashText = CrashActivity.this.getShareText(CrashActivity.this.model);
                            CrashActivity.this.shareText(crashText);
                        } else if (id2 == R.id.menu_share_image) {
                            if (ContextCompat.checkSelfPermission((Context)CrashActivity.this, (String)"android.permission.READ_EXTERNAL_STORAGE") == -1 || ContextCompat.checkSelfPermission((Context)CrashActivity.this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == -1) {
                                CrashActivity.this.requestPermission(new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"});
                            } else {
                                CrashActivity.this.shareImage();
                            }
                        }
                        return true;
                    }
                });
            }
        });
    }

    private String getShareText(CrashModel model) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getString(R.string.simpleCrashInfo)).append("\n").append(model.getExceptionMsg()).append("\n");
        builder.append("\n");
        builder.append(this.getString(R.string.simpleClassName)).append(model.getFileName()).append("\n");
        builder.append("\n");
        builder.append(this.getString(R.string.simpleFunName)).append(model.getMethodName()).append("\n");
        builder.append("\n");
        builder.append(this.getString(R.string.simpleLineNum)).append(model.getLineNumber()).append("\n");
        builder.append("\n");
        builder.append(this.getString(R.string.simpleExceptionType)).append(model.getExceptionType()).append("\n");
        builder.append("\n");
        builder.append(this.getString(R.string.simpleTime)).append(this.df.format(model.getTime())).append("\n");
        builder.append("\n");
        builder.append(this.getString(R.string.simpleModel)).append(model.getDevice().getModel()).append("\n");
        builder.append("\n");
        builder.append(this.getString(R.string.simpleBrand)).append(model.getDevice().getBrand()).append("\n");
        builder.append("\n");
        builder.append(this.getString(R.string.simpleVersion)).append(model.getDevice().getVersion()).append("\n");
        builder.append("\n");
        builder.append(this.getString(R.string.simpleAllInfo)).append("\n").append(model.getFullException()).append("\n");
        return builder.toString();
    }

    private void shareText(String text) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.SUBJECT", this.getString(R.string.simpleCrashInfo));
        intent.putExtra("android.intent.extra.TEXT", text);
        intent.setFlags(0x10000000);
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)this.getString(R.string.simpleShareTo)));
    }

    private void requestPermission(String ... permissions) {
        ActivityCompat.requestPermissions((Activity)this, (String[])permissions, (int)110);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 110) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                this.shareImage();
            } else {
                this.showToast(R.string.simplePermissionSd);
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    public Bitmap getBitmapByView(ViewGroup toolbar, ScrollView scrollView) {
        if (toolbar == null || scrollView == null) {
            return null;
        }
        Paint paint = new Paint(1);
        int svHeight = 0;
        for (int i = 0; i < scrollView.getChildCount(); ++i) {
            svHeight += scrollView.getChildAt(i).getHeight();
        }
        int height = svHeight + toolbar.getHeight();
        Bitmap resultBitmap = Bitmap.createBitmap((int)toolbar.getWidth(), (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas rootCanvas = new Canvas(resultBitmap);
        Bitmap toolbarBitmap = Bitmap.createBitmap((int)toolbar.getWidth(), (int)toolbar.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas toolbarCanvas = new Canvas(toolbarBitmap);
        toolbarCanvas.drawRGB(255, 255, 255);
        toolbar.draw(toolbarCanvas);
        Bitmap svBitmap = Bitmap.createBitmap((int)toolbar.getWidth(), (int)svHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas svCanvas = new Canvas(svBitmap);
        svCanvas.drawRGB(255, 255, 255);
        scrollView.draw(svCanvas);
        rootCanvas.drawBitmap(toolbarBitmap, 0.0f, 0.0f, paint);
        rootCanvas.drawBitmap(svBitmap, 0.0f, (float)toolbar.getHeight(), paint);
        return resultBitmap;
    }

    private File BitmapToFile(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        String path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath();
        File imageFile = new File(path, "spiderMan-" + this.df.format(this.model.getTime()) + ".jpg");
        try {
            FileOutputStream out = new FileOutputStream(imageFile);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
            out.flush();
            out.close();
            bitmap.recycle();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return imageFile;
    }

    private void shareImage() {
        if (!Environment.getExternalStorageState().equals("mounted")) {
            this.showToast(R.string.simpleNoSdCard);
            return;
        }
        File file = this.BitmapToFile(this.getBitmapByView(this.toolbar, this.scrollView));
        if (file == null || !file.exists()) {
            this.showToast(R.string.simpleImageNotExist);
            return;
        }
        Intent intent = new Intent();
        intent.setAction("android.intent.action.SEND");
        intent.setType("image/*");
        if (Build.VERSION.SDK_INT >= 24) {
            Uri contentUri = FileProvider.getUriForFile((Context)this.getApplicationContext(), (String)(this.getApplicationContext().getPackageName() + ".spidermanfileprovider"), (File)file);
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)contentUri);
        } else {
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.fromFile((File)file));
        }
        intent.setFlags(0x10000000);
        intent.addFlags(1);
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)this.getString(R.string.simpleShareTo)));
    }

    private void showToast(String text) {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)text, (int)0).show();
    }

    private void showToast(@StringRes int textId) {
        Toast.makeText((Context)this.getApplicationContext(), (int)textId, (int)0).show();
    }
}

