/*
 * Decompiled with CFR 0.152.
 */
package com.simple.spiderman;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.os.Process;
import android.support.annotation.StyleRes;
import com.simple.spiderman.CrashActivity;
import com.simple.spiderman.CrashModel;
import com.simple.spiderman.R;
import com.simple.spiderman.Utils;

public class SpiderMan
implements Thread.UncaughtExceptionHandler {
    public static final String TAG = "SpiderMan";
    private static SpiderMan spiderMan = new SpiderMan();
    private static Context mContext;
    public static int mThemeId;

    private SpiderMan() {
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    public static SpiderMan init(Context context) {
        mContext = context;
        return spiderMan;
    }

    @Override
    public void uncaughtException(Thread t, Throwable ex) {
        CrashModel model = Utils.parseCrash(ex);
        this.handleException(model);
        Process.killProcess((int)Process.myPid());
    }

    public void setTheme(@StyleRes int themeId) {
        mThemeId = themeId;
    }

    private void handleException(CrashModel model) {
        Intent intent = new Intent(mContext, CrashActivity.class);
        intent.putExtra("crash_model", (Parcelable)model);
        intent.setFlags(0x10000000);
        mContext.startActivity(intent);
    }

    static {
        mThemeId = R.style.SpiderManTheme_Light;
    }
}

