/*
 * Decompiled with CFR 0.152.
 */
package com.simple.spiderman;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.os.Process;
import com.simple.spiderman.CrashActivity;
import com.simple.spiderman.CrashModel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;

public class SpiderMan
implements Thread.UncaughtExceptionHandler {
    private static SpiderMan spiderMan = new SpiderMan();
    private Context mContext;
    private Thread.UncaughtExceptionHandler mExceptionHandler;
    private Builder mBuilder;

    private SpiderMan() {
    }

    public static SpiderMan getInstance() {
        return spiderMan;
    }

    public Builder init(Context context) {
        this.mContext = context;
        this.mExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.mBuilder = new Builder();
        return this.mBuilder;
    }

    @Override
    public void uncaughtException(Thread t, Throwable ex) {
        if (this.mBuilder == null) {
            return;
        }
        CrashModel model = this.parseCrash(ex);
        if (this.mBuilder.mOnCrashListener != null) {
            this.mBuilder.mOnCrashListener.onCrash(t, ex, model);
        }
        if (this.mBuilder.mEnable) {
            this.handleException(model);
        } else if (this.mExceptionHandler != null) {
            this.mExceptionHandler.uncaughtException(t, ex);
        }
    }

    private void handleException(CrashModel model) {
        if (this.mBuilder.mEnable && this.mBuilder.mShowCrashMessage) {
            Intent intent = new Intent(this.mContext, CrashActivity.class);
            intent.putExtra("crash_model", (Parcelable)model);
            intent.setFlags(0x10000000);
            this.mContext.startActivity(intent);
        }
        Process.killProcess((int)Process.myPid());
    }

    private CrashModel parseCrash(Throwable ex) {
        CrashModel model = new CrashModel();
        model.setEx(ex);
        model.setTime(new Date().getTime());
        StringBuilder msgBuilder = new StringBuilder();
        String exceptionMsg = null;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        String exceptionType = ex.getClass().getName();
        exceptionMsg = ex.getMessage();
        msgBuilder.append(ex.getMessage());
        msgBuilder.append("\n");
        if (ex.getStackTrace() != null && ex.getStackTrace().length > 0) {
            StackTraceElement element = ex.getStackTrace()[0];
            model.setExceptionMsg(exceptionMsg);
            model.setLineNumber(element.getLineNumber());
            model.setClassName(element.getClassName());
            model.setFileName(element.getFileName());
            model.setMethodName(element.getMethodName());
            model.setExceptionType(exceptionType);
        }
        model.setFullException(sw.toString());
        return model;
    }

    public class Builder {
        private boolean mEnable;
        private boolean mShowCrashMessage;
        private OnCrashListener mOnCrashListener;

        public Builder setEnable(boolean enable) {
            this.mEnable = enable;
            return this;
        }

        public Builder showCrashMessage(boolean show) {
            this.mShowCrashMessage = show;
            return this;
        }

        public void setOnCrashListener(OnCrashListener listener) {
            this.mOnCrashListener = listener;
        }
    }

    public static interface OnCrashListener {
        public void onCrash(Thread var1, Throwable var2, CrashModel var3);
    }
}

