/*
 * Decompiled with CFR 0.152.
 */
package com.simple.spiderman;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.FileProvider;
import android.support.v7.app.AppCompatActivity;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.PopupMenu;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import com.google.gson.Gson;
import com.simple.spiderman.CrashModel;
import com.simple.spiderman.R;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.Map;

public class CrashActivity
extends AppCompatActivity {
    public static final String CRASH_MODEL = "crash_model";
    @SuppressLint(value={"SimpleDateFormat"})
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private CrashModel model;
    private View root;
    private static final int REQUEST_CODE = 110;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_crash);
        this.model = (CrashModel)this.getIntent().getParcelableExtra(CRASH_MODEL);
        if (this.model == null) {
            return;
        }
        this.model.getEx().printStackTrace();
        this.root = this.findViewById(R.id.root);
        TextView tv_packageName = (TextView)this.findViewById(R.id.tv_packageName);
        TextView textMessage = (TextView)this.findViewById(R.id.textMessage);
        TextView tv_className = (TextView)this.findViewById(R.id.tv_className);
        TextView tv_methodName = (TextView)this.findViewById(R.id.tv_methodName);
        TextView tv_lineNumber = (TextView)this.findViewById(R.id.tv_lineNumber);
        TextView tv_exceptionType = (TextView)this.findViewById(R.id.tv_exceptionType);
        TextView tv_fullException = (TextView)this.findViewById(R.id.tv_fullException);
        TextView tv_time = (TextView)this.findViewById(R.id.tv_time);
        TextView tv_model = (TextView)this.findViewById(R.id.tv_model);
        TextView tv_brand = (TextView)this.findViewById(R.id.tv_brand);
        TextView tv_version = (TextView)this.findViewById(R.id.tv_version);
        ImageView iv_more = (ImageView)this.findViewById(R.id.iv_more);
        tv_packageName.setText((CharSequence)this.model.getClassName());
        textMessage.setText((CharSequence)this.model.getExceptionMsg());
        tv_className.setText((CharSequence)this.model.getFileName());
        tv_methodName.setText((CharSequence)this.model.getMethodName());
        tv_lineNumber.setText((CharSequence)String.valueOf(this.model.getLineNumber()));
        tv_exceptionType.setText((CharSequence)this.model.getExceptionType());
        tv_fullException.setText((CharSequence)this.model.getFullException());
        tv_time.setText((CharSequence)this.df.format(this.model.getTime()));
        tv_model.setText((CharSequence)this.model.getDevice().getModel());
        tv_brand.setText((CharSequence)this.model.getDevice().getBrand());
        tv_version.setText((CharSequence)this.model.getDevice().getVersion());
        iv_more.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PopupMenu menu2 = new PopupMenu((Context)CrashActivity.this, v);
                menu2.inflate(R.menu.menu_more);
                menu2.show();
                menu2.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener(){

                    public boolean onMenuItemClick(MenuItem item) {
                        int id2 = item.getItemId();
                        if (id2 == R.id.menu_copy_text) {
                            String json = new Gson().toJson((Object)CrashActivity.this.modelToMap(CrashActivity.this.model));
                            ClipboardManager cm = (ClipboardManager)CrashActivity.this.getSystemService("clipboard");
                            if (cm != null) {
                                ClipData mClipData = ClipData.newPlainText((CharSequence)"crash", (CharSequence)json);
                                cm.setPrimaryClip(mClipData);
                                CrashActivity.this.showToast("\u62f7\u8d1d\u6210\u529f");
                            }
                        } else if (id2 == R.id.menu_share_text) {
                            String json = new Gson().toJson((Object)CrashActivity.this.modelToMap(CrashActivity.this.model));
                            CrashActivity.this.shareText(json);
                        } else if (id2 == R.id.menu_share_image) {
                            if (ContextCompat.checkSelfPermission((Context)CrashActivity.this, (String)"android.permission.READ_EXTERNAL_STORAGE") == -1 || ContextCompat.checkSelfPermission((Context)CrashActivity.this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == -1) {
                                CrashActivity.this.requestPermission(new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"});
                            } else {
                                CrashActivity.this.shareImage();
                            }
                        }
                        return true;
                    }
                });
            }
        });
    }

    private Map<String, Object> modelToMap(CrashModel model) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("\u5d29\u6e83\u4fe1\u606f", model.getExceptionMsg());
        map.put("\u7c7b\u540d", model.getFileName());
        map.put("\u65b9\u6cd5", model.getMethodName());
        map.put("\u884c\u6570", model.getLineNumber());
        map.put("\u7c7b\u578b", model.getExceptionType());
        map.put("\u65f6\u95f4", this.df.format(model.getTime()));
        map.put("\u8bbe\u5907\u540d\u79f0", model.getDevice().getModel());
        map.put("\u8bbe\u5907\u5382\u5546", model.getDevice().getBrand());
        map.put("\u7cfb\u7edf\u7248\u672c", model.getDevice().getVersion());
        map.put("\u5168\u90e8\u4fe1\u606f", model.getFullException());
        return map;
    }

    private void shareText(String text) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.SUBJECT", "\u5d29\u6e83\u4fe1\u606f\uff1a");
        intent.putExtra("android.intent.extra.TEXT", text);
        intent.setFlags(0x10000000);
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"\u5206\u4eab\u5230"));
    }

    private void requestPermission(String ... permissions) {
        ActivityCompat.requestPermissions((Activity)this, (String[])permissions, (int)110);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 110) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                this.shareImage();
            } else {
                this.showToast("\u8bf7\u6388\u4e88SD\u5361\u6743\u9650\u624d\u80fd\u5206\u4eab\u56fe\u7247");
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    public Bitmap getBitmapByView(ScrollView view) {
        if (view == null) {
            return null;
        }
        int height = 0;
        for (int i = 0; i < view.getChildCount(); ++i) {
            height += view.getChildAt(i).getHeight();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawRGB(255, 255, 255);
        view.draw(canvas);
        return bitmap;
    }

    private File BitmapToFile(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        String path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath();
        File imageFile = new File(path, "spiderMan-" + this.df.format(this.model.getTime()) + ".jpg");
        try {
            FileOutputStream out = new FileOutputStream(imageFile);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
            out.flush();
            out.close();
            bitmap.recycle();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return imageFile;
    }

    private void shareImage() {
        if (!Environment.getExternalStorageState().equals("mounted")) {
            this.showToast("\u672a\u63d2\u5165sd\u5361");
            return;
        }
        File file = this.BitmapToFile(this.getBitmapByView((ScrollView)this.findViewById(R.id.scrollView)));
        if (file == null || !file.exists()) {
            this.showToast("\u56fe\u7247\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        Intent intent = new Intent();
        intent.setAction("android.intent.action.SEND");
        intent.setType("image/*");
        if (Build.VERSION.SDK_INT >= 24) {
            Uri contentUri = FileProvider.getUriForFile((Context)this.getApplicationContext(), (String)(this.getApplicationContext().getPackageName() + ".spidermanfileprovider"), (File)file);
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)contentUri);
        } else {
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.fromFile((File)file));
        }
        intent.setFlags(0x10000000);
        intent.addFlags(1);
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"\u5206\u4eab\u56fe\u7247"));
    }

    private void showToast(String text) {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)text, (int)0).show();
    }
}

