/*
 * Decompiled with CFR 0.152.
 */
package com.simple.spiderman;

import android.content.Context;
import android.content.Intent;
import android.os.Process;
import com.simple.spiderman.CrashActivity;
import java.io.Serializable;

public class SpiderMan
implements Thread.UncaughtExceptionHandler {
    private static SpiderMan spiderMan = new SpiderMan();
    private Context mContext;
    private Thread.UncaughtExceptionHandler mExceptionHandler;
    private Builder mBuilder;

    private SpiderMan() {
    }

    public static SpiderMan getInstance() {
        return spiderMan;
    }

    public Builder init(Context context) {
        this.mContext = context;
        this.mExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.mBuilder = new Builder();
        return this.mBuilder;
    }

    @Override
    public void uncaughtException(Thread t, Throwable ex) {
        if (this.mBuilder == null) {
            if (this.mExceptionHandler == null) {
                return;
            }
            this.mExceptionHandler.uncaughtException(t, ex);
            return;
        }
        if (this.mBuilder.mOnCrashListener != null) {
            this.mBuilder.mOnCrashListener.onCrash(t, ex);
        }
        if (this.mBuilder.mEnable) {
            this.handleException(ex);
        } else if (this.mExceptionHandler != null) {
            this.mExceptionHandler.uncaughtException(t, ex);
        }
    }

    private void handleException(Throwable ex) {
        if (this.mBuilder.mEnable && this.mBuilder.mShowCrashMessage) {
            Intent intent = new Intent(this.mContext, CrashActivity.class);
            intent.putExtra("exception_msg", (Serializable)ex);
            intent.setFlags(0x10000000);
            this.mContext.startActivity(intent);
        }
        Process.killProcess((int)Process.myPid());
    }

    public class Builder {
        private boolean mEnable;
        private boolean mShowCrashMessage;
        private OnCrashListener mOnCrashListener;

        public Builder setEnable(boolean enable) {
            this.mEnable = enable;
            return this;
        }

        public Builder showCrashMessage(boolean show) {
            this.mShowCrashMessage = show;
            return this;
        }

        public void setOnCrashListener(OnCrashListener listener) {
            this.mOnCrashListener = listener;
        }
    }

    public static interface OnCrashListener {
        public void onCrash(Thread var1, Throwable var2);
    }
}

