/*
 * Decompiled with CFR 0.152.
 */
package com.simple.spiderman;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.simple.spiderman.Item;
import com.simple.spiderman.R;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class CrashActivity
extends Activity {
    public static final String EXCEPTION_MSG = "exception_msg";
    private List<Item> itemList = new ArrayList<Item>();

    protected void onCreate(Bundle savedInstanceState) {
        Throwable ex;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_crash);
        ex.printStackTrace();
        StringBuilder msgBuilder = new StringBuilder();
        String exceptionMsg = null;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        String exceptionType = ex.getClass().getName();
        for (ex = (Throwable)this.getIntent().getSerializableExtra(EXCEPTION_MSG); ex != null; ex = ex.getCause()) {
            exceptionMsg = ex.getMessage();
            msgBuilder.append(ex.getMessage());
            msgBuilder.append("\n");
            if (ex.getStackTrace() == null || ex.getStackTrace().length <= 0) continue;
            StackTraceElement element = ex.getStackTrace()[0];
            Item item = new Item();
            item.setLineNumber(element.getLineNumber());
            item.setClassName(element.getClassName());
            item.setFileName(element.getFileName());
            item.setMethodName(element.getMethodName());
            item.setExceptionType(exceptionType);
            this.itemList.add(item);
        }
        LayoutInflater inflater = LayoutInflater.from((Context)this);
        View headerView = inflater.inflate(R.layout.header, null);
        TextView textMessage = (TextView)headerView.findViewById(R.id.textMessage);
        textMessage.setText((CharSequence)exceptionMsg);
        ListView listView = (ListView)this.findViewById(R.id.listView);
        listView.addHeaderView(headerView);
        listView.setAdapter((ListAdapter)new Adpater());
        View footerView = inflater.inflate(R.layout.footer, null);
        TextView tvFooter = (TextView)footerView.findViewById(R.id.tv_footer);
        tvFooter.setText((CharSequence)sw.toString());
        listView.addFooterView(footerView);
    }

    public class Adpater
    extends BaseAdapter {
        public int getCount() {
            return CrashActivity.this.itemList.size();
        }

        public Object getItem(int position) {
            return CrashActivity.this.itemList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            Item item = (Item)CrashActivity.this.itemList.get(position);
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)CrashActivity.this).inflate(R.layout.item_info, parent, false);
                holder = new ViewHolder(convertView);
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            holder.mTvClassName.setText((CharSequence)item.getFileName());
            holder.mTvMethodName.setText((CharSequence)item.getMethodName());
            holder.mTvLineNumber.setText((CharSequence)String.valueOf(item.getLineNumber()));
            holder.mExceptionType.setText((CharSequence)item.getExceptionType());
            return convertView;
        }

        public final class ViewHolder {
            public TextView mTvClassName;
            public TextView mTvMethodName;
            public TextView mTvLineNumber;
            public TextView mExceptionType;

            public ViewHolder(View itemView) {
                this.mTvClassName = (TextView)itemView.findViewById(R.id.tv_className);
                this.mTvMethodName = (TextView)itemView.findViewById(R.id.tv_methodName);
                this.mTvLineNumber = (TextView)itemView.findViewById(R.id.tv_lineNumber);
                this.mExceptionType = (TextView)itemView.findViewById(R.id.tv_exceptionType);
            }
        }
    }
}

