/*
 * Decompiled with CFR 0.152.
 */
package com.simplaapliko.updater;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.fragment.app.DialogFragment;
import com.simplaapliko.updater.R;

public class ChangeLogDialog
extends DialogFragment {
    private static final String TITLE_KEY = "TITLE_KEY";
    private static final String CHANGE_LOG_KEY = "CHANGE_LOG_KEY";
    private static final String HAS_POSITIVE_BUTTON_KEY = "HAS_POSITIVE_BUTTON_KEY";
    private DialogInterface.OnDismissListener mOnDismissListener;
    private String mTitle;
    private String mChangeLog;
    private boolean mHasPositiveButton;

    private static ChangeLogDialog newInstance(String title, String changeLog, boolean hasPositiveButton) {
        ChangeLogDialog fragment = new ChangeLogDialog();
        Bundle args = new Bundle();
        args.putString(TITLE_KEY, title);
        args.putString(CHANGE_LOG_KEY, changeLog);
        args.putBoolean(HAS_POSITIVE_BUTTON_KEY, hasPositiveButton);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null) {
            this.mTitle = args.getString(TITLE_KEY);
            if (this.mTitle == null) {
                this.mTitle = this.getString(R.string.u_change_log_title);
            }
            this.mChangeLog = args.getString(CHANGE_LOG_KEY);
            this.mHasPositiveButton = args.getBoolean(HAS_POSITIVE_BUTTON_KEY);
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        View view = View.inflate((Context)this.getContext(), (int)R.layout.u_dialog_fragment_change_log, null);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setView(view);
        builder.setTitle((CharSequence)this.mTitle);
        if (this.mHasPositiveButton) {
            builder.setPositiveButton(17039370, (dialog, which) -> dialog.dismiss());
        }
        ((WebView)view.findViewById(R.id.description)).loadDataWithBaseURL(null, this.mChangeLog, "text/html", "utf-8", null);
        return builder.create();
    }

    public void onDetach() {
        this.mOnDismissListener = null;
        super.onDetach();
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }

    public DialogInterface.OnDismissListener getOnDismissListener() {
        return this.mOnDismissListener;
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    public static class Builder {
        private String mTitle;
        private String mChangeLog;
        private boolean mHasPositiveButton;

        public Builder setTitle(String title) {
            this.mTitle = title;
            return this;
        }

        public Builder setChangeLog(String changeLog) {
            this.mChangeLog = changeLog;
            return this;
        }

        public Builder setHasPositiveButton(boolean hasPositiveButton) {
            this.mHasPositiveButton = hasPositiveButton;
            return this;
        }

        public ChangeLogDialog build() {
            return ChangeLogDialog.newInstance(this.mTitle, this.mChangeLog, this.mHasPositiveButton);
        }
    }
}

