/*
 * Decompiled with CFR 0.152.
 */
package com.simplaapliko.updater;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.simplaapliko.updater.PreferencesHelper;
import com.simplaapliko.updater.Versions;
import java.util.List;

public class Updater {
    private static final String TAG = "Updater";
    private Context mContext;
    private int mNewVersionCode;
    private int mOldVersionCode;
    private String mNewVersionName;
    private String mOldVersionName;

    public Updater(Context context) {
        this.mContext = context.getApplicationContext();
        try {
            PackageInfo packageInfo = this.mContext.getPackageManager().getPackageInfo(this.mContext.getPackageName(), 128);
            this.mNewVersionCode = packageInfo.versionCode;
            this.mNewVersionName = packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"unable to get version code.", (Throwable)e);
            this.mNewVersionCode = -1;
            this.mNewVersionName = null;
        }
        this.mOldVersionCode = new PreferencesHelper(this.mContext).getVersionCode();
        this.mOldVersionName = new PreferencesHelper(this.mContext).getVersionName();
    }

    public int getNewVersionCode() {
        return this.mNewVersionCode;
    }

    public int getOldVersionCode() {
        return this.mOldVersionCode;
    }

    public String getNewVersionName() {
        return this.mNewVersionName;
    }

    public String getOldVersionName() {
        return this.mOldVersionName;
    }

    public String getNewMajorVersionName() {
        return Versions.getMajorVersion(this.mNewVersionName);
    }

    public String getOldMajorVersionName() {
        return Versions.getMajorVersion(this.mOldVersionName);
    }

    public String getNewMinorVersionName() {
        return Versions.getMinorVersion(this.mNewVersionName);
    }

    public String getOldMinorVersionName() {
        return Versions.getMinorVersion(this.mOldVersionName);
    }

    public String getNewPatchVersionName() {
        return Versions.getPatchVersion(this.mNewVersionName);
    }

    public String getOldPatchVersionName() {
        return Versions.getPatchVersion(this.mOldVersionName);
    }

    public boolean isFirstLaunch() {
        return this.mOldVersionCode == -1;
    }

    public boolean isVersionCodeChanged() {
        return this.mOldVersionCode != -1 && this.mNewVersionCode != this.mOldVersionCode;
    }

    public boolean isVersionNameChanged() {
        if (this.mNewVersionName == null || this.mOldVersionName == null) {
            return false;
        }
        return Versions.compareVersion(this.mNewVersionName, this.mOldVersionName) != 0;
    }

    public boolean isMajorVersionChanged() {
        String oldVersion;
        if (this.mNewVersionName == null || this.mOldVersionName == null) {
            return false;
        }
        String newVersion = Versions.getMajorVersion(this.mNewVersionName);
        return Versions.compareVersion(newVersion, oldVersion = Versions.getMajorVersion(this.mOldVersionName)) == 1;
    }

    public boolean isMinorVersionChanged() {
        String oldVersion;
        if (this.mNewVersionName == null || this.mOldVersionName == null) {
            return false;
        }
        if (this.isMajorVersionChanged()) {
            return true;
        }
        String newVersion = Versions.getMinorVersion(this.mNewVersionName);
        return Versions.compareVersion(newVersion, oldVersion = Versions.getMinorVersion(this.mOldVersionName)) == 1;
    }

    public boolean isPatchVersionChanged() {
        String oldVersion;
        if (this.mNewVersionName == null || this.mOldVersionName == null) {
            return false;
        }
        if (this.isMinorVersionChanged()) {
            return true;
        }
        String newVersion = Versions.getPatchVersion(this.mNewVersionName);
        return Versions.compareVersion(newVersion, oldVersion = Versions.getPatchVersion(this.mOldVersionName)) == 1;
    }

    public void onVersionChanged(List<OnVersionChangeListener> listeners) {
        for (OnVersionChangeListener listener : listeners) {
            listener.onVersionChange();
        }
        PreferencesHelper preferencesHelper = new PreferencesHelper(this.mContext);
        preferencesHelper.setVersionCode(this.mNewVersionCode);
        preferencesHelper.setVersionName(this.mNewVersionName);
    }

    public static interface OnVersionChangeListener {
        public void onVersionChange();
    }
}

