/*
 * Decompiled with CFR 0.152.
 */
package com.simplaapliko.updater;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.simplaapliko.updater.PreferencesHelper;
import java.util.List;

public class Updater {
    private static final String TAG = "Updater";
    private Context mContext;
    private int mNewVersionCode;
    private int mOldVersionCode;

    public Updater(Context context) {
        this.mContext = context.getApplicationContext();
        try {
            PackageInfo packageInfo = this.mContext.getPackageManager().getPackageInfo(this.mContext.getPackageName(), 128);
            this.mNewVersionCode = packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"unable to get version code.", (Throwable)e);
            this.mNewVersionCode = -1;
        }
        this.mOldVersionCode = new PreferencesHelper(this.mContext).getVersion();
    }

    public int getNewVersion() {
        return this.mNewVersionCode;
    }

    public int getOldVersion() {
        return this.mOldVersionCode;
    }

    public boolean isFirstLaunch() {
        return this.mOldVersionCode == -1;
    }

    public boolean isVersionChanged() {
        return this.mOldVersionCode != -1 && this.mNewVersionCode > this.mOldVersionCode;
    }

    public void onVersionChanged(List<OnVersionChangeListener> listeners) {
        for (OnVersionChangeListener listener : listeners) {
            this.update(listener);
        }
        new PreferencesHelper(this.mContext).setVersion(this.mNewVersionCode);
    }

    private void update(OnVersionChangeListener listener) {
        listener.onVersionChange();
    }

    public static interface OnVersionChangeListener {
        public void onVersionChange();
    }
}

