/*
 * Copyright (C) 2016 Oleg Kan, @Simplaapliko
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.simplaapliko.updater;

import android.content.Context;

public class PreferencesHelper {

    private static final String PREFERENCES = "com.simplaapliko.updater.preferences";

    private static final String PREF_VERSION = "version";

    static final int VERSION_NOT_FOUND = -1;

    private Context mContext;


    // Constructors

    PreferencesHelper(Context context) {
        mContext = context;
    }


    // Default API

    int getVersion() {
        return mContext.getSharedPreferences(PREFERENCES, Context.MODE_PRIVATE)
                .getInt(PREF_VERSION, VERSION_NOT_FOUND);
    }

    void setVersion(int version) {
        mContext.getSharedPreferences(PREFERENCES, Context.MODE_PRIVATE)
                .edit()
                .putInt(PREF_VERSION, version)
                .commit();
    }

}
