/*
 * Decompiled with CFR 0.152.
 */
package com.simplaapliko.updater;

import android.content.Context;
import com.simplaapliko.updater.PreferencesHelper;

public class Updater {
    public static int getCurrentVersion(Context context) {
        return new PreferencesHelper(context).getVersion();
    }

    public static boolean isVersionChanged(Context context, int newVersion) {
        int oldVersion = new PreferencesHelper(context).getVersion();
        return newVersion != oldVersion;
    }

    public static void updateOnVersionChanged(Context context, int newVersion, OnVersionUpdateListener listener) {
        Updater.update(listener);
        new PreferencesHelper(context).setVersion(newVersion);
    }

    private static void update(OnVersionUpdateListener listener) {
        listener.onVersionUpdate();
    }

    public static interface OnVersionUpdateListener {
        public void onVersionUpdate();
    }
}

