/*
 * Copyright (C) 2016 Oleg Kan, @Simplaapliko
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.simplaapliko.updater;

import android.content.Context;

public class Updater {

    // Inner classes

    public interface OnVersionUpdateListener {
        void onVersionUpdate();
    }


    // Constructors

    public Updater() {

    }


    // Public API

    public static int getCurrentVersion(Context context) {

        return new PreferencesHelper(context)
                .getVersion();
    }

    public static boolean isVersionChanged(Context context, int newVersion) {

        int oldVersion = new PreferencesHelper(context)
                .getVersion();

        return newVersion != oldVersion;
    }

    public static void updateOnVersionChanged(Context context, int newVersion, OnVersionUpdateListener listener) {

        update(listener);

        new PreferencesHelper(context)
                .setVersion(newVersion);
    }


    // Private API

    private static void update(OnVersionUpdateListener listener) {
        listener.onVersionUpdate();
    }

}
