/*
 * Decompiled with CFR 0.152.
 */
package com.simplaapliko.apprater;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import com.simplaapliko.apprater.PreferencesHelper;
import com.simplaapliko.apprater.R;
import java.util.Date;
import java.util.List;

public final class AppRater {
    private static final int DAY = 86400000;

    public static void appLaunched(Activity activity) {
        AppRater.appLaunched(activity, null, null, null);
    }

    public static void appLaunched(Activity activity, DialogInterface.OnClickListener onPositiveButtonListener, DialogInterface.OnClickListener onNegativeButtonListener, DialogInterface.OnClickListener onNeutralButtonListener) {
        PreferencesHelper preferences = new PreferencesHelper((Context)activity);
        if (preferences.isDoNoShowAgain()) {
            return;
        }
        AppRater.increment((Context)activity);
        if (AppRater.isTimeToRate((Context)activity)) {
            AppRater.showDialog(activity, onPositiveButtonListener, onNegativeButtonListener, onNeutralButtonListener);
        }
    }

    public static void showDialog(Activity activity) {
        AppRater.showDialog(activity, null, null, null);
    }

    public static void showDialog(Activity activity, DialogInterface.OnClickListener onPositiveButtonListener, DialogInterface.OnClickListener onNegativeButtonListener, DialogInterface.OnClickListener onNeutralButtonListener) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity).setCancelable(true).setTitle(R.string.ar_dialog_rate_title).setMessage(R.string.ar_dialog_rate_message);
        if (onPositiveButtonListener != null) {
            builder.setPositiveButton(R.string.ar_dialog_rate_positive_button_rate, (dialog, which) -> {
                AppRater.rateApp((Context)activity);
                onPositiveButtonListener.onClick(dialog, which);
            });
        }
        if (onNegativeButtonListener != null) {
            builder.setNegativeButton(R.string.ar_dialog_rate_negative_button, (dialog, which) -> {
                AppRater.remindLater((Context)activity);
                onNegativeButtonListener.onClick(dialog, which);
            });
        }
        if (onNeutralButtonListener != null) {
            builder.setNeutralButton(R.string.ar_dialog_rate_neutral_button, (dialog, which) -> {
                AppRater.cancelReminders((Context)activity);
                onNeutralButtonListener.onClick(dialog, which);
            });
        }
        builder.create().show();
    }

    public static void increment(Context context) {
        PreferencesHelper preferences = new PreferencesHelper(context);
        int launchCount = preferences.getLaunchCount() + 1;
        preferences.setLaunchCount(launchCount);
        long firstLaunchDate = preferences.getFirstLaunchDate();
        if (firstLaunchDate == 0L) {
            preferences.setFirstLaunchDate(System.currentTimeMillis());
        }
    }

    public static Date getFirstLaunchDate(Context context) {
        PreferencesHelper preferences = new PreferencesHelper(context);
        long firstLaunchDate = preferences.getFirstLaunchDate();
        return new Date(firstLaunchDate);
    }

    public static int getLaunchCount(Context context) {
        PreferencesHelper preferences = new PreferencesHelper(context);
        return preferences.getLaunchCount();
    }

    public static boolean isDoNotShowAgain(Context context) {
        PreferencesHelper preferences = new PreferencesHelper(context);
        return preferences.isDoNoShowAgain();
    }

    public static boolean isTimeToRate(Context context) {
        PreferencesHelper preferences = new PreferencesHelper(context);
        Resources resources = context.getResources();
        int dayUntilPrompt = resources.getInteger(R.integer.ar_app_rater_days_until_prompt);
        int launchesUntilPrompt = resources.getInteger(R.integer.ar_app_rater_launches_until_prompt);
        int launchCount = preferences.getLaunchCount();
        long firstLaunchDate = preferences.getFirstLaunchDate();
        return !preferences.isDoNoShowAgain() && launchCount >= launchesUntilPrompt && System.currentTimeMillis() >= firstLaunchDate + (long)(dayUntilPrompt * 86400000);
    }

    public static void rateApp(Context context) {
        new PreferencesHelper(context).setDoNoShowAgain(true);
        Intent rate = new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + context.getPackageName())));
        if (!AppRater.isIntentCallable(context, rate)) {
            rate = new Intent("android.intent.action.VIEW", Uri.parse((String)("http://play.google.com/store/apps/details?id=" + context.getPackageName())));
        }
        if (!AppRater.isIntentCallable(context, rate)) {
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.ar_unable_to_find_google_play), (int)1).show();
            return;
        }
        if (context instanceof Activity) {
            context.startActivity(rate);
        } else {
            Intent intent = Intent.createChooser((Intent)rate, null);
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    public static void remindLater(Context context) {
        new PreferencesHelper(context).setLaunchCount(0).setFirstLaunchDate(System.currentTimeMillis());
    }

    public static void cancelReminders(Context context) {
        new PreferencesHelper(context).setDoNoShowAgain(true);
    }

    public static boolean isFirstLaunch(Context context) {
        return new PreferencesHelper(context).getFirstLaunchDate() == 0L;
    }

    private static boolean isIntentCallable(Context context, Intent intent) {
        List list = context.getPackageManager().queryIntentActivities(intent, 65536);
        return list.size() > 0;
    }
}

