/*
 * Decompiled with CFR 0.152.
 */
package com.simplaapliko.apprater;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.view.View;
import android.widget.TextView;
import com.simplaapliko.apprater.AppRater;
import com.simplaapliko.apprater.R;

public class RateAppDialog
extends DialogFragment {
    private static final String TITLE_KEY = "TITLE_KEY";
    private static final String MESSAGE_KEY = "MESSAGE_KEY";
    private static final String POSITIVE_BUTTON_KEY = "POSITIVE_BUTTON_KEY";
    private static final String NEGATIVE_BUTTON_KEY = "NEGATIVE_BUTTON_KEY";
    private static final String NEUTRAL_BUTTON_KEY = "NEUTRAL_BUTTON_KEY";
    private int mTitle;
    private int mMessage;
    private int mPositiveButton;
    private int mNegativeButton;
    private int mNeutralButton;
    private DialogInterface.OnClickListener mOnPositiveButtonListener;
    private DialogInterface.OnClickListener mOnNegativeButtonListener;
    private DialogInterface.OnClickListener mOnNeutralButtonListener;

    private static RateAppDialog newInstance(int title, int message, int positiveButton, int negativeButton, int neutralButton) {
        RateAppDialog fragment = new RateAppDialog();
        Bundle args = new Bundle();
        args.putInt(TITLE_KEY, title);
        args.putInt(MESSAGE_KEY, message);
        args.putInt(POSITIVE_BUTTON_KEY, positiveButton);
        args.putInt(NEGATIVE_BUTTON_KEY, negativeButton);
        args.putInt(NEUTRAL_BUTTON_KEY, neutralButton);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setCancelable(true);
        Bundle args = this.getArguments();
        if (args != null) {
            this.mTitle = args.getInt(TITLE_KEY);
            this.mMessage = args.getInt(MESSAGE_KEY);
            this.mPositiveButton = args.getInt(POSITIVE_BUTTON_KEY);
            this.mNegativeButton = args.getInt(NEGATIVE_BUTTON_KEY);
            this.mNeutralButton = args.getInt(NEUTRAL_BUTTON_KEY);
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        View rootView = this.getActivity().getLayoutInflater().inflate(R.layout.ar_dialog_fragment_rate_app, null);
        this.initUiWidgets(rootView);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setTitle(this.mTitle);
        builder.setPositiveButton(this.mPositiveButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                AppRater.rateApp(RateAppDialog.this.getContext());
                if (RateAppDialog.this.mOnPositiveButtonListener != null) {
                    RateAppDialog.this.mOnPositiveButtonListener.onClick(dialog, which);
                }
                dialog.dismiss();
            }
        });
        builder.setNegativeButton(this.mNegativeButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                AppRater.remindLater(RateAppDialog.this.getContext());
                if (RateAppDialog.this.mOnNegativeButtonListener != null) {
                    RateAppDialog.this.mOnNegativeButtonListener.onClick(dialog, which);
                }
                dialog.dismiss();
            }
        });
        builder.setNeutralButton(this.mNeutralButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                AppRater.cancelReminders(RateAppDialog.this.getContext());
                if (RateAppDialog.this.mOnNeutralButtonListener != null) {
                    RateAppDialog.this.mOnNeutralButtonListener.onClick(dialog, which);
                }
                dialog.dismiss();
            }
        });
        builder.setView(rootView);
        return builder.create();
    }

    public DialogInterface.OnClickListener getOnPositiveButtonListener() {
        return this.mOnPositiveButtonListener;
    }

    public void setOnPositiveButtonListener(DialogInterface.OnClickListener onPositiveButtonListener) {
        this.mOnPositiveButtonListener = onPositiveButtonListener;
    }

    public DialogInterface.OnClickListener getOnNegativeButtonListener() {
        return this.mOnNegativeButtonListener;
    }

    public void setOnNegativeButtonListener(DialogInterface.OnClickListener onNegativeButtonListener) {
        this.mOnNegativeButtonListener = onNegativeButtonListener;
    }

    public DialogInterface.OnClickListener getOnNeutralButtonListener() {
        return this.mOnNeutralButtonListener;
    }

    public void setOnNeutralButtonListener(DialogInterface.OnClickListener onNeutralButtonListener) {
        this.mOnNeutralButtonListener = onNeutralButtonListener;
    }

    private void initUiWidgets(View rootView) {
        TextView appNameTextView = (TextView)rootView.findViewById(R.id.message);
        appNameTextView.setText(this.mMessage);
    }

    public static class Builder {
        private int mTitle = R.string.ar_dialog_rate_title;
        private int mMessage = R.string.ar_dialog_rate_message;
        private int mPositiveButton = R.string.ar_dialog_rate_positive_button_rate;
        private int mNegativeButton = R.string.ar_dialog_rate_negative_button;
        private int mNeutralButton = R.string.ar_dialog_rate_neutral_button;

        public Builder setTitle(int title) {
            this.mTitle = title;
            return this;
        }

        public Builder setMessage(int message) {
            this.mMessage = message;
            return this;
        }

        public Builder setPositiveButton(int positiveButton) {
            this.mPositiveButton = positiveButton;
            return this;
        }

        public Builder setNegativeButton(int negativeButton) {
            this.mNegativeButton = negativeButton;
            return this;
        }

        public Builder setNeutralButton(int neutralButton) {
            this.mNeutralButton = neutralButton;
            return this;
        }

        public RateAppDialog build() {
            return RateAppDialog.newInstance(this.mTitle, this.mMessage, this.mPositiveButton, this.mNegativeButton, this.mNeutralButton);
        }
    }
}

