/*
 * Decompiled with CFR 0.152.
 */
package com.simplaapliko.apprater;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.widget.Toast;
import com.simplaapliko.apprater.PreferencesHelper;
import com.simplaapliko.apprater.R;
import com.simplaapliko.apprater.RateAppDialog;
import java.util.List;

public final class AppRater {
    private static final int DAY = 86400000;

    public static void appLaunched(@NonNull FragmentActivity activity) {
        AppRater.appLaunched(activity, null, null, null);
    }

    public static void appLaunched(@NonNull FragmentActivity activity, DialogInterface.OnClickListener onPositiveButtonListener, DialogInterface.OnClickListener onNegativeButtonListener, DialogInterface.OnClickListener onNeutralButtonListener) {
        int dayUntilPrompt = activity.getResources().getInteger(R.integer.ar_app_rater_days_until_prompt);
        int launchesUntilPrompt = activity.getResources().getInteger(R.integer.ar_app_rater_launches_until_prompt);
        PreferencesHelper preferences = new PreferencesHelper((Context)activity);
        if (preferences.isDoNoShowAgain()) {
            return;
        }
        int launchCount = preferences.getLaunchCount() + 1;
        preferences.setLaunchCount(launchCount);
        long firstLaunchDate = preferences.getFirstLaunchDate();
        if (firstLaunchDate == 0L) {
            preferences.setFirstLaunchDate(System.currentTimeMillis());
        }
        if (launchCount >= launchesUntilPrompt && System.currentTimeMillis() >= firstLaunchDate + (long)(dayUntilPrompt * 86400000)) {
            RateAppDialog dialog = new RateAppDialog.Builder().build();
            if (onPositiveButtonListener != null) {
                dialog.setOnPositiveButtonListener(onPositiveButtonListener);
            }
            if (onNegativeButtonListener != null) {
                dialog.setOnNegativeButtonListener(onNegativeButtonListener);
            }
            if (onNeutralButtonListener != null) {
                dialog.setOnNeutralButtonListener(onNeutralButtonListener);
            }
            dialog.show(activity.getSupportFragmentManager(), null);
        }
    }

    public static void rateApp(Context context) {
        new PreferencesHelper(context).setDoNoShowAgain(true);
        Intent rate = new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + context.getPackageName())));
        if (!AppRater.isIntentCallable(context, rate)) {
            rate = new Intent("android.intent.action.VIEW", Uri.parse((String)("http://play.google.com/store/apps/details?id=" + context.getPackageName())));
        }
        if (!AppRater.isIntentCallable(context, rate)) {
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.ar_unable_to_find_google_play), (int)1).show();
            return;
        }
        if (context instanceof Activity) {
            context.startActivity(rate);
        } else {
            Intent intent = Intent.createChooser((Intent)rate, null);
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    public static void remindLater(Context context) {
        new PreferencesHelper(context).setLaunchCount(0).setFirstLaunchDate(System.currentTimeMillis());
    }

    public static void cancelReminders(Context context) {
        new PreferencesHelper(context).setDoNoShowAgain(true);
    }

    public static boolean isFirstLaunch(Context context) {
        return new PreferencesHelper(context).getFirstLaunchDate() == 0L;
    }

    private static boolean isIntentCallable(Context context, Intent intent) {
        List list = context.getPackageManager().queryIntentActivities(intent, 65536);
        return list.size() > 0;
    }
}

