/*
 * Decompiled with CFR 0.152.
 */
package com.simplaapliko.apprater;

import android.content.Context;

public class PreferencesHelper {
    private static final String PREFERENCES = "com.simplaapliko.apprater.preferences";
    private static final String PREF_FIRST_LAUNCH_DATE = "first_launch_date";
    private static final String PREF_LAUNCH_COUNT = "launch_count";
    private static final String PREF_DO_NOT_SHOW_AGAIN = "do_not_show_again";
    static final int NOT_SET = 0;
    private Context mContext;

    PreferencesHelper(Context context) {
        this.mContext = context;
    }

    long getFirstLaunchDate() {
        return this.mContext.getSharedPreferences(PREFERENCES, 0).getLong(PREF_FIRST_LAUNCH_DATE, 0L);
    }

    PreferencesHelper setFirstLaunchDate(long date) {
        this.mContext.getSharedPreferences(PREFERENCES, 0).edit().putLong(PREF_FIRST_LAUNCH_DATE, date).commit();
        return this;
    }

    int getLaunchCount() {
        return this.mContext.getSharedPreferences(PREFERENCES, 0).getInt(PREF_LAUNCH_COUNT, 0);
    }

    PreferencesHelper setLaunchCount(int count) {
        this.mContext.getSharedPreferences(PREFERENCES, 0).edit().putInt(PREF_LAUNCH_COUNT, count).commit();
        return this;
    }

    boolean isDoNoShowAgain() {
        return this.mContext.getSharedPreferences(PREFERENCES, 0).getBoolean(PREF_DO_NOT_SHOW_AGAIN, false);
    }

    PreferencesHelper setDoNoShowAgain(boolean enabled) {
        this.mContext.getSharedPreferences(PREFERENCES, 0).edit().putBoolean(PREF_DO_NOT_SHOW_AGAIN, enabled).commit();
        return this;
    }
}

