/*
 * Decompiled with CFR 0.152.
 */
package com.simplaapliko.apprater;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.net.Uri;
import android.support.v7.app.AppCompatActivity;
import android.widget.Toast;
import com.simplaapliko.apprater.R;
import com.simplaapliko.apprater.RateAppDialog;

public final class AppRater {
    public static final int DAYS_UNTIL_PROMPT = 7;
    public static final int LAUNCHES_UNTIL_PROMPT = 10;
    private static final String PREFS_APP_RATER = "PREFS_APP_RATER";
    private static final String PREF_FIRST_DATE_LAUNCH = "FIRST_DATE_LAUNCH";
    private static final String PREF_LAUNCH_COUNT = "LAUNCH_COUNT";
    private static final String PREF_DO_NOT_SHOW_AGAIN = "DO_NOT_SHOW_AGAIN";

    public static void appLaunched(Context context) {
        int launchesUntilPrompt;
        int dayUntilPrompt;
        try {
            dayUntilPrompt = context.getResources().getInteger(R.integer.app_rater_days_until_prompt);
        }
        catch (Resources.NotFoundException ex) {
            dayUntilPrompt = 7;
        }
        try {
            launchesUntilPrompt = context.getResources().getInteger(R.integer.app_rater_launches_until_prompt);
        }
        catch (Resources.NotFoundException ex) {
            launchesUntilPrompt = 10;
        }
        SharedPreferences prefs = context.getSharedPreferences(PREFS_APP_RATER, 0);
        if (prefs.getBoolean(PREF_DO_NOT_SHOW_AGAIN, false)) {
            return;
        }
        SharedPreferences.Editor editor = prefs.edit();
        int launchCount = prefs.getInt(PREF_LAUNCH_COUNT, 0) + 1;
        editor.putInt(PREF_LAUNCH_COUNT, launchCount);
        long firstDateLaunch = prefs.getLong(PREF_FIRST_DATE_LAUNCH, 0L);
        if (firstDateLaunch == 0L) {
            firstDateLaunch = System.currentTimeMillis();
            editor.putLong(PREF_FIRST_DATE_LAUNCH, firstDateLaunch);
        }
        editor.apply();
        if (launchCount >= launchesUntilPrompt && System.currentTimeMillis() >= firstDateLaunch + (long)(dayUntilPrompt * 24 * 60 * 60 * 1000)) {
            RateAppDialog dialog = new RateAppDialog.Builder().build();
            dialog.show(((AppCompatActivity)context).getSupportFragmentManager(), null);
        }
    }

    public static void rateApp(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(PREFS_APP_RATER, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean(PREF_DO_NOT_SHOW_AGAIN, true);
        editor.apply();
        try {
            context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + context.getPackageName()))));
        }
        catch (ActivityNotFoundException e) {
            context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("http://play.google.com/store/apps/details?id=" + context.getPackageName()))));
        }
        catch (Exception e) {
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.unable_to_find_google_play), (int)1).show();
        }
    }

    public static void remindLater(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(PREFS_APP_RATER, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putInt(PREF_LAUNCH_COUNT, 0);
        long dateFirstLaunch = System.currentTimeMillis();
        editor.putLong(PREF_FIRST_DATE_LAUNCH, dateFirstLaunch);
        editor.apply();
    }

    public static void cancelReminders(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(PREFS_APP_RATER, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean(PREF_DO_NOT_SHOW_AGAIN, true);
        editor.apply();
    }

    public static boolean isFirstLaunch(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(PREFS_APP_RATER, 0);
        return prefs.getLong(PREF_FIRST_DATE_LAUNCH, 0L) == 0L;
    }
}

