/*
 * Decompiled with CFR 0.152.
 */
package com.silverforge.controls.calculators;

import com.silverforge.controls.calculators.LoadCalculator;
import com.silverforge.controls.model.ItemCoordinate;

public class InfiniteLoadCalculator
extends LoadCalculator {
    private static final int INITIAL_INNER_POINT_ANGLE = 270;
    private ItemCoordinate[] outerItems;
    private ItemCoordinate innerItem;

    public void initializePointPosition(float centerX, float centerY, float smallRadius, float smallPointRadius) {
        this.innerItem = this.getItemCoordinate(centerX, centerY, 270.0f, smallRadius, smallPointRadius);
    }

    public void initializeOuterPointPositions(float centerX, float centerY, float bigRadius, float bigPointRadius, int bigPointCount) {
        this.outerItems = new ItemCoordinate[bigPointCount];
        float slice = 360 / bigPointCount;
        for (int i = 0; i < bigPointCount; ++i) {
            ItemCoordinate itemCoordinate;
            int angle = (int)(slice * (float)i);
            this.outerItems[i] = itemCoordinate = this.getItemCoordinate(centerX, centerY, angle, bigRadius, bigPointRadius);
        }
    }

    public void recalculatePointPosition(float centerX, float centerY, float deltaAngleInDegrees, float radius) {
        float innerItemAngle = this.innerItem.getAngle();
        if ((innerItemAngle -= deltaAngleInDegrees) < 0.0f) {
            innerItemAngle += 360.0f;
        }
        this.recalculateItemCoordinate(centerX, centerY, innerItemAngle, radius, this.innerItem);
    }

    public void recalculateOuterPointPositions(float centerX, float centerY, float deltaAngleInDegrees, float radius) {
        for (ItemCoordinate item : this.outerItems) {
            float itemAngle = item.getAngle();
            if ((itemAngle += deltaAngleInDegrees) > 360.0f) {
                itemAngle -= 360.0f;
            }
            this.recalculateItemCoordinate(centerX, centerY, itemAngle, radius, item);
        }
    }

    public ItemCoordinate[] getOuterItems() {
        return this.outerItems;
    }

    public ItemCoordinate getInnerItem() {
        return this.innerItem;
    }
}

