/*
 * Decompiled with CFR 0.152.
 */
package com.silverforge.controls;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import com.silverforge.controls.Indicator;
import com.silverforge.controls.LoaderAngleAnimation;
import com.silverforge.controls.LoaderTextAnimation;
import com.silverforge.controls.calculators.CoordinateCalculator;
import com.silverforge.controls.calculators.FiniteLoadCalculator;
import com.silverforge.controls.calculators.InfiniteLoadCalculator;
import com.silverforge.controls.model.ItemCoordinate;
import com.silverforge.controls.model.PositionSettings;
import com.silverforge.controls.painters.CanvasPainter;

public final class BusyIndicator
extends Indicator {
    private boolean firstLoad = true;
    private Bitmap canvasBackground;
    private RectF rect = new RectF();
    private float maxValue;
    private float currentValue;
    private int angleModifier;
    private float arcAngle;
    private int textAlpha;
    private float layOutCenterX;
    private float layOutCenterY;
    private float bigRadius;
    private float singleRadius;
    private float singlePointRadius;
    private float textPosX;
    private float textPosY;
    private CanvasPainter canvasPainter = new CanvasPainter();
    private InfiniteLoadCalculator infiniteLoadCalculator = new InfiniteLoadCalculator();
    private FiniteLoadCalculator finiteLoadCalculator = new FiniteLoadCalculator();

    public BusyIndicator(Context context) {
        this(context, null);
    }

    public BusyIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BusyIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.firstLoad) {
            this.initialize();
            this.firstLoad = false;
        } else if (this.configSettings.isInfinite()) {
            this.calculateInfiniteMoves();
        }
        if (this.configSettings.isBackgroundVisible()) {
            canvas.drawBitmap(this.canvasBackground, 0.0f, 0.0f, null);
        }
        if (this.configSettings.isInfinite()) {
            this.drawInfiniteIndicator(canvas);
        } else {
            this.drawLoadingIndicator(canvas);
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        int action = event.getAction();
        switch (action) {
            case 1: {
                this.angleModifier = this.configSettings.getAngleModifier();
                break;
            }
            case 0: {
                this.angleModifier += 3;
            }
        }
        return true;
    }

    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public void setValue(float value) {
        this.calculateProgress(value);
    }

    public void setValue(int value) {
        this.calculateProgress(value);
    }

    public void setAngleModifier(int angleModifier) {
        if (angleModifier > 3) {
            angleModifier = 3;
        }
        if (angleModifier < 1) {
            angleModifier = 1;
        }
        this.angleModifier = angleModifier;
        this.configSettings.setAngleModifier(angleModifier);
    }

    float getArcAngle() {
        return this.arcAngle;
    }

    void setArcAngle(float aa) {
        this.arcAngle = aa;
    }

    int getTextAlpha() {
        return this.textAlpha;
    }

    void setTextAlpha(int ta) {
        this.textAlpha = ta;
    }

    private void initialize() {
        int height = this.getHeight();
        int width = this.getWidth();
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        CoordinateCalculator coordinateCalculator = new CoordinateCalculator();
        PositionSettings positionSettings = coordinateCalculator.calculateBasePositions(width, height, paddingLeft, paddingTop);
        this.initializeCalculators(positionSettings);
        this.initializePaints(positionSettings);
        this.initializeTextPositions(positionSettings);
        this.initializeCanvas(positionSettings);
        this.layOutCenterX = positionSettings.getLayOutCenterX();
        this.layOutCenterY = positionSettings.getLayOutCenterY();
        this.bigRadius = positionSettings.getBigRadius();
        this.singleRadius = positionSettings.getSingleRadius();
        this.singlePointRadius = positionSettings.getSinglePointRadius();
        this.angleModifier = this.configSettings.getAngleModifier();
    }

    private void initializeCalculators(PositionSettings posSettings) {
        float layOutCenterX = posSettings.getLayOutCenterX();
        float layOutCenterY = posSettings.getLayOutCenterY();
        float bigRadius = posSettings.getBigRadius();
        float bigPointRadius = posSettings.getBigPointRadius();
        int bigPointCount = this.configSettings.getBigPointCount();
        float singleRadius = posSettings.getSingleRadius();
        float singlePointRadius = posSettings.getSinglePointRadius();
        if (this.configSettings.isInfinite()) {
            this.infiniteLoadCalculator.initializeOuterPointPositions(layOutCenterX, layOutCenterY, bigRadius, bigPointRadius, bigPointCount);
            this.infiniteLoadCalculator.initializePointPosition(layOutCenterX, layOutCenterY, singleRadius, singlePointRadius);
        } else {
            this.finiteLoadCalculator.initializeOuterPointPositions(layOutCenterX, layOutCenterY, bigRadius, singlePointRadius, bigPointCount);
        }
    }

    private void initializePaints(PositionSettings posSettings) {
        float bigRadius = posSettings.getBigRadius();
        float singlePointRadius = posSettings.getSinglePointRadius();
        float strokeWidthMultiplier = this.configSettings.getStrokeWidthMultiplier();
        int indicatorAlpha = this.configSettings.getIndicatorAlpha();
        this.canvasPainter.initializePaints(this.configSettings.getBigPointColor(), this.configSettings.getSmallPointColor(), bigRadius, singlePointRadius, strokeWidthMultiplier, indicatorAlpha);
    }

    private void initializeTextPositions(PositionSettings posSettings) {
        float layOutCenterX = posSettings.getLayOutCenterX();
        float layOutCenterY = posSettings.getLayOutCenterY();
        float descent = this.canvasPainter.getTextPaint().descent();
        float ascent = this.canvasPainter.getTextPaint().ascent();
        this.textPosX = layOutCenterX;
        this.textPosY = layOutCenterY - (descent + ascent) / 2.0f;
    }

    private void initializeCanvas(PositionSettings posSettings) {
        Bitmap cb = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas cv = new Canvas(cb);
        cv.drawColor(this.configSettings.getBackgroundColor());
        this.canvasBackground = this.canvasPainter.getRoundedBitmap(cb, this.configSettings.getBackgroundShape());
        float layOutCenterX = posSettings.getLayOutCenterX();
        float layOutCenterY = posSettings.getLayOutCenterY();
        float bigRadius = posSettings.getBigRadius();
        this.rect.set(layOutCenterX - bigRadius, layOutCenterY - bigRadius, layOutCenterX + bigRadius, layOutCenterY + bigRadius);
    }

    private void calculateProgress(float value) {
        if (value > 0.0f) {
            if (value >= this.maxValue) {
                value = this.maxValue;
            }
            this.currentValue = value;
            float currentAngle = 360.0f / this.maxValue * value;
            float aa = (currentAngle += 270.0f) - 270.0f;
            LoaderAngleAnimation angleAnimation = new LoaderAngleAnimation(this, aa);
            angleAnimation.setDuration(300L);
            LoaderTextAnimation textAnimation = new LoaderTextAnimation(this);
            textAnimation.setDuration(300L);
            AnimationSet animationSet = new AnimationSet(false);
            animationSet.addAnimation((Animation)angleAnimation);
            animationSet.addAnimation((Animation)textAnimation);
            this.startAnimation((Animation)animationSet);
        }
    }

    private void drawInfiniteIndicator(Canvas canvas) {
        Paint bigPaint = this.canvasPainter.getBigPaint();
        for (ItemCoordinate item : this.infiniteLoadCalculator.getOuterItems()) {
            canvas.drawCircle(item.getX(), item.getY(), item.getRadius(), bigPaint);
        }
        ItemCoordinate innerItem = this.infiniteLoadCalculator.getInnerItem();
        Paint singlePaint = this.canvasPainter.getSinglePaint();
        canvas.drawCircle(innerItem.getX(), innerItem.getY(), this.singlePointRadius, singlePaint);
        this.invalidate();
    }

    private void drawLoadingIndicator(Canvas canvas) {
        canvas.drawArc(this.rect, 630.0f, this.arcAngle, false, this.canvasPainter.getSinglePaintTransparent());
        if (this.configSettings.isLoadPointsAreVisible()) {
            for (ItemCoordinate item : this.finiteLoadCalculator.getOuterItems()) {
                float itemAngle = item.getAngle();
                itemAngle = itemAngle >= 270.0f ? (itemAngle -= 270.0f) : (itemAngle += 90.0f);
                if (itemAngle > this.arcAngle) {
                    this.canvasPainter.getBigPaint().setAlpha(100);
                    canvas.drawCircle(item.getX(), item.getY(), this.singlePointRadius, this.canvasPainter.getBigPaint());
                    continue;
                }
                canvas.drawCircle(item.getX(), item.getY(), this.singlePointRadius, this.canvasPainter.getSinglePaint());
            }
        }
        if (this.configSettings.isPercentageVisible()) {
            float v = 100.0f / this.maxValue * this.currentValue;
            String formatString = (String)this.decimalPlacesMap.get(this.configSettings.getPercentageDecimalPlaces());
            String text = String.format(formatString, Float.valueOf(v));
            float descent = this.canvasPainter.getTextPaint().descent();
            float ascent = this.canvasPainter.getTextPaint().ascent();
            this.textPosY = this.layOutCenterY - (descent + ascent) / 2.0f;
            this.canvasPainter.getTextPaint().setAlpha(this.textAlpha);
            canvas.drawText(text, this.textPosX, this.textPosY, this.canvasPainter.getTextPaint());
        }
    }

    private void calculateInfiniteMoves() {
        this.infiniteLoadCalculator.recalculateOuterPointPositions(this.layOutCenterX, this.layOutCenterY, this.angleModifier, this.bigRadius);
        this.infiniteLoadCalculator.recalculatePointPosition(this.layOutCenterX, this.layOutCenterY, this.angleModifier, this.singleRadius);
    }
}

