/*
 * Decompiled with CFR 0.152.
 */
package com.silicornio.geormlite.utils;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import com.silicornio.geormlite.GeDatabaseFieldJson;
import com.silicornio.geormlite.general.GEL;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public class GEReflectionUtils {
    public static Field getFieldId(Class klass) {
        try {
            for (Field field : klass.getDeclaredFields()) {
                Annotation[] annotations;
                Class<?> type = field.getType();
                String name = field.getName();
                if (type != String.class) continue;
                for (Annotation annotation : annotations = field.getDeclaredAnnotations()) {
                    if (!(annotation instanceof DatabaseField) || !((DatabaseField)annotation).id()) continue;
                    field.setAccessible(true);
                    return field;
                }
            }
        }
        catch (Exception e) {
            GEL.e("Exception getting field from object: " + e.toString());
        }
        return null;
    }

    public static Field getFieldJson(Class klass) {
        try {
            for (Field field : klass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(GeDatabaseFieldJson.class)) continue;
                field.setAccessible(true);
                return field;
            }
        }
        catch (Exception e) {
            GEL.e("Exception getting field from object: " + e.toString());
        }
        return null;
    }

    public static String getTableName(Class klass) {
        try {
            Annotation[] annotations;
            for (Annotation annotation : annotations = klass.getDeclaredAnnotations()) {
                if (!(annotation instanceof DatabaseTable)) continue;
                return ((DatabaseTable)annotation).tableName();
            }
        }
        catch (Exception e) {
            GEL.e("Exception getting table name from object: " + e.toString());
        }
        return null;
    }

    public static Field getField(Class klass, String fieldName) {
        try {
            for (Field field : klass.getDeclaredFields()) {
                Class<?> type = field.getType();
                String name = field.getName();
                if (!name.equals(fieldName)) continue;
                return field;
            }
            Class superKlass = klass.getSuperclass();
            if (superKlass != null) {
                return GEReflectionUtils.getField(superKlass, fieldName);
            }
        }
        catch (Exception e) {
            GEL.e("Exception getting field '" + fieldName + "' from class '" + klass.toString() + "': " + e.toString());
        }
        return null;
    }

    public static Field getAnnotation(Class klass, String sAnnotation) {
        try {
            for (Annotation annotation : klass.getAnnotations()) {
            }
        }
        catch (Exception e) {
            GEL.e("Exception getting annotation value '" + sAnnotation + "' from class '" + klass.toString() + "': " + e.toString());
        }
        return null;
    }
}

