/*
 * Decompiled with CFR 0.152.
 */
package com.silicornio.geormlite.general;

import android.util.Log;
import java.text.SimpleDateFormat;

public class GEL {
    private static final int TYPE_D = 0;
    private static final int TYPE_I = 1;
    private static final int TYPE_W = 2;
    private static final int TYPE_E = 3;
    private static final boolean DATETIME_SHOW = false;
    private static final String DATETIME_FORMAT = "HH:mm:ss.SSS";
    private static final String PREFIX_LOG = "Googlyeyes";
    public static boolean showLogs = false;
    private static SimpleDateFormat simpleDateFormat;

    public static void d(String text) {
        GEL.log(text, 0);
    }

    public static void i(String text) {
        GEL.log(text, 1);
    }

    public static void w(String text) {
        GEL.log(text, 2);
    }

    public static void e(String text) {
        GEL.log(text, 3);
    }

    private static void log(String text, int type) {
        if (showLogs) {
            String sClass = "";
            String sMethod = "";
            String sLine = "";
            StackTraceElement[] stackTraceElements = new Throwable().getStackTrace();
            if (stackTraceElements.length > 2) {
                sClass = stackTraceElements[2].getClassName();
                int pos = sClass.lastIndexOf(".");
                if (pos != -1) {
                    sClass = sClass.substring(pos + 1);
                }
                sMethod = stackTraceElements[2].getMethodName();
                sLine = String.valueOf(stackTraceElements[2].getLineNumber());
            }
            GEL.log(sClass, sLine, sMethod, text, type);
        }
    }

    private static void log(String sClass, String sLine, String sMethod, String text, int type) {
        if (showLogs) {
            try {
                String str = GEL.getTextLog(sClass, sLine, sMethod, text);
                switch (type) {
                    case 0: {
                        Log.d((String)PREFIX_LOG, (String)str);
                        break;
                    }
                    case 1: {
                        Log.i((String)PREFIX_LOG, (String)str);
                        break;
                    }
                    case 2: {
                        Log.w((String)PREFIX_LOG, (String)str);
                        break;
                    }
                    case 3: {
                        Log.e((String)PREFIX_LOG, (String)str);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String getTextLog(String sClass, String sLine, String sMethod, String text) {
        try {
            if (simpleDateFormat == null) {
                simpleDateFormat = new SimpleDateFormat(DATETIME_FORMAT);
            }
            String sLog = "(" + sClass + ".java:" + sLine + ") [" + sMethod + "]: " + text + "\n";
            return sLog;
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
    }
}

