/*
 * Decompiled with CFR 0.152.
 */
package com.silicornio.geormlite;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import com.j256.ormlite.android.apptools.OpenHelperManager;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.dao.RuntimeExceptionDao;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import com.silicornio.geormlite.GeOrmLiteHelper;
import com.silicornio.geormlite.general.GEL;
import com.silicornio.geormlite.utils.GEDateUtils;
import com.silicornio.geormlite.utils.GEJsonUtils;
import com.silicornio.geormlite.utils.GEReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Pattern;

public abstract class GeOrmLiteManager {
    public static final String DATETIME_FORMAT_ORMLITE = "yyyy-MM-dd HH:mm:ss.SSSSSS";
    public static final String DATE_FORMAT_ORMLITE = "yyyy-MM-dd";
    protected static Class[] classes;
    protected static String databaseName;
    protected static int databaseVersion;
    private OrmLiteSqliteOpenHelper mDatabaseHelper = null;
    private static GeOrmLiteManager mInstance;
    private RuntimeExceptionDao[] mDaos;
    private Field[] mDaosId;
    private Field[] mDaosJson;

    private GeOrmLiteManager() {
    }

    public GeOrmLiteManager(Context context) {
        classes = this.getClasses();
        databaseName = this.getDatabaseName();
        databaseVersion = this.getDatabaseVersion();
        this.mDatabaseHelper = OpenHelperManager.getHelper((Context)context, GeOrmLiteHelper.class);
        this.generateDaos();
    }

    public abstract Class[] getClasses();

    public abstract String getDatabaseName();

    public abstract int getDatabaseVersion();

    public abstract void onGeUpgrade(SQLiteDatabase var1, ConnectionSource var2, int var3, int var4);

    public static void onGeDbUpgrade(SQLiteDatabase database, ConnectionSource connectionSource, int oldVersion, int newVersion) {
        GeOrmLiteManager.onGeDbUpgrade(database, connectionSource, oldVersion, newVersion);
    }

    private void generateDaos() {
        this.mDaos = new RuntimeExceptionDao[classes.length];
        this.mDaosId = new Field[classes.length];
        this.mDaosJson = new Field[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            this.mDaos[i] = this.mDatabaseHelper.getRuntimeExceptionDao(classes[i]);
            this.mDaosId[i] = GEReflectionUtils.getFieldId(classes[i]);
            this.mDaosJson[i] = GEReflectionUtils.getFieldJson(classes[i]);
        }
    }

    public void destroy() {
        mInstance = null;
    }

    private int getIndexClass(Class oClass) throws IllegalArgumentException {
        for (int i = 0; i < this.mDaos.length; ++i) {
            if (!classes[i].equals(oClass)) continue;
            return i;
        }
        throw new IllegalArgumentException("Dao NOT FOUND for class: " + oClass.toString());
    }

    private RuntimeExceptionDao getDao(Object o) throws IllegalArgumentException {
        return this.getDao(o.getClass());
    }

    private RuntimeExceptionDao getDao(Class c) throws IllegalArgumentException {
        return this.mDaos[this.getIndexClass(c)];
    }

    private String getId(Object o) throws IllegalArgumentException {
        return (String)GeOrmLiteManager.getValue(this.mDaosId[this.getIndexClass(o.getClass())], o);
    }

    private Field getDaoJson(Object obj) throws IllegalArgumentException {
        return this.getDaoJson(obj.getClass());
    }

    private Field getDaoJson(Class c) throws IllegalArgumentException {
        return this.mDaosJson[this.getIndexClass(c)];
    }

    private static Object getFieldValue(Object obj, String fieldName) {
        try {
            Field field = GEReflectionUtils.getField(obj.getClass(), fieldName);
            field.setAccessible(true);
            return GeOrmLiteManager.getValue(field, obj);
        }
        catch (Exception e) {
            GEL.e("Exception getting value '" + fieldName + "' from an object ' " + obj.getClass().toString() + "': " + e.toString());
            return null;
        }
    }

    private static Object getValue(Field field, Object o) {
        try {
            return field.get(o);
        }
        catch (Exception e) {
            GEL.e("Exception getting value from an object: " + e.toString());
            return null;
        }
    }

    public void updateJsonData(Object o) {
        GEJsonUtils.updateJsonData(o, this.getDaoJson(o));
    }

    private <T> T checkJsonData(T t) {
        if (t == null) {
            return null;
        }
        Field field = this.getDaoJson(t.getClass());
        if (field == null) {
            return t;
        }
        return GEJsonUtils.getObjectFromJsonData(t, field);
    }

    private <T> List<T> checkJsonData(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return list;
        }
        Field field = this.getDaoJson(list.get(0).getClass());
        if (field == null) {
            return list;
        }
        ArrayList<T> listT = new ArrayList<T>();
        for (T t : list) {
            listT.add(GEJsonUtils.getObjectFromJsonData(t, field));
        }
        return listT;
    }

    public void addOrUpdate(Object object) {
        if (!this.update(object)) {
            this.add(object);
        }
    }

    public void add(Object object) {
        try {
            this.updateJsonData(object);
            this.getDao(object).create(object);
        }
        catch (Exception e) {
            GEL.e("Exception adding object: " + e.toString());
        }
    }

    public <T> List<T> getAll(Class<T> t) {
        return this.getAll(t, null, false, 0L);
    }

    public <T> List<T> getAll(Class<T> t, String orderBy, boolean ascending, long limit) {
        try {
            QueryBuilder queryBuilder = this.getDao(t).queryBuilder();
            if (orderBy != null) {
                queryBuilder.orderBy(orderBy, ascending);
                if (limit > 0L) {
                    queryBuilder.limit(Long.valueOf(limit));
                }
            }
            return this.checkJsonData(queryBuilder.query());
        }
        catch (Exception e) {
            GEL.e("Exception getting all objects: " + e.toString());
            return null;
        }
    }

    public <T> T getFirst(Class<T> t) {
        try {
            List<T> listT = this.getAll(t, null, false, 1L);
            if (listT.size() > 0) {
                return listT.get(0);
            }
        }
        catch (Exception e) {
            GEL.e("Exception getting first object: " + e.toString());
        }
        return null;
    }

    public <T> T getObjectById(Class klass, String id) {
        try {
            return (T)this.checkJsonData(this.getDao(klass).queryForId((Object)id));
        }
        catch (Exception e) {
            GEL.e("Exception getting object by id: " + e.toString());
            return null;
        }
    }

    public <T> T getObjectById(T t) {
        try {
            return (T)this.checkJsonData(this.getDao(t).queryForId((Object)this.getId(t)));
        }
        catch (Exception e) {
            GEL.e("Exception getting object by id: " + e.toString());
            return null;
        }
    }

    public <T> T getFirstObjectByFields(T t, String fields) {
        try {
            List<T> listT = this.getObjectsByFields(t, fields);
            if (listT.size() > 0) {
                return listT.get(0);
            }
        }
        catch (Exception e) {
            GEL.e("Exception getting first object by id: " + e.toString());
        }
        return null;
    }

    public <T> List<T> getObjectsByFields(T t, String fields) {
        return this.getObjectsByFields(t, fields, null, false);
    }

    public <T> List<T> getObjectsByFields(Class<T> klass, String fields) {
        return this.getObjectsByFields(klass, fields, (String)null, false);
    }

    public <T> List<T> getObjectsByFields(T t, String fields, String orderBy, boolean ascending) {
        try {
            return this.checkJsonData(this.getWhereByFields(t, fields, orderBy, ascending).query());
        }
        catch (Exception e) {
            GEL.e("Exception getting objects by fields: " + e.toString());
            return null;
        }
    }

    public <T> List<T> getObjectsByFields(Class<T> klass, String fields, String orderBy, boolean ascending) {
        try {
            return this.checkJsonData(this.getWhereByFields(klass, fields, orderBy, ascending).query());
        }
        catch (Exception e) {
            GEL.e("Exception getting objects by fields: " + e.toString());
            return null;
        }
    }

    public <T> Where getWhereByFields(T t, String fields, String orderBy, boolean ascending) {
        QueryBuilder queryBuilder = this.getDao(t).queryBuilder();
        Where where = this.whereByFields((StatementBuilder)queryBuilder, t, fields);
        if (orderBy != null) {
            queryBuilder.orderBy(orderBy, ascending);
        }
        return where;
    }

    public <T> Where getWhereByFields(Class<T> klass, String fields, String orderBy, boolean ascending) {
        QueryBuilder queryBuilder = this.getDao(klass).queryBuilder();
        Where where = this.whereByFields((StatementBuilder)queryBuilder, null, fields);
        if (orderBy != null) {
            queryBuilder.orderBy(orderBy, ascending);
        }
        return where;
    }

    public <T> Where whereByFields(StatementBuilder builder, T t, String fields) {
        try {
            Where where = builder.where();
            String[] aFields = fields.split(",");
            for (int i = 0; i < aFields.length; ++i) {
                Object oValue;
                String field = aFields[i].replace(" ", "");
                Pattern pattern = Pattern.compile("[=<>]+");
                String[] aField = pattern.split(field);
                String operation = "=";
                if (aField.length == 2) {
                    operation = field.substring(aField[0].length(), field.length() - aField[1].length());
                    oValue = aField[1];
                    field = aField[0];
                } else if (t != null) {
                    oValue = GeOrmLiteManager.getFieldValue(t, field);
                } else {
                    oValue = null;
                    GEL.e("Trying to get the value of the field '" + field + "' but not sending the object or the value with '='");
                }
                where = this.applyWhere(where, operation, field, oValue, i == 0);
            }
            return where;
        }
        catch (Exception e) {
            GEL.e("Exception getting object by fields: " + e.toString());
            return null;
        }
    }

    private Where applyWhere(Where where, String operation, String field, Object value, boolean firstValue) {
        try {
            where = firstValue ? (operation.equals("<") ? where.lt(field, value) : (operation.equals(">") ? where.gt(field, value) : (operation.equals("<=") ? where.le(field, value) : (operation.equals(">=") ? where.ge(field, value) : where.eq(field, value))))) : (operation.equals("<") ? where.and().lt(field, value) : (operation.equals(">") ? where.and().gt(field, value) : (operation.equals("<=") ? where.and().le(field, value) : (operation.equals(">=") ? where.and().ge(field, value) : where.and().eq(field, value)))));
            return where;
        }
        catch (Exception e) {
            GEL.e("Exception applying where with field and value: " + e.toString());
            return null;
        }
    }

    public <T> int getNumObjectsByFields(T t, String fields) {
        try {
            return (int)this.getWhereByFields(t, fields, null, false).countOf();
        }
        catch (Exception e) {
            GEL.e("Exception getting objects by fields: " + e.toString());
            return 0;
        }
    }

    public <T> int getNumObjectsByFields(Class<T> klass, String fields) {
        try {
            return (int)this.getWhereByFields(klass, fields, (String)null, false).countOf();
        }
        catch (Exception e) {
            GEL.e("Exception getting objects by fields: " + e.toString());
            return 0;
        }
    }

    public <T> List<T> getObjectsByField(T t, List<String> values, String field) {
        try {
            if (values.size() == 0) {
                return new ArrayList();
            }
            QueryBuilder queryBuilder = this.getDao(t).queryBuilder();
            Where where = queryBuilder.where();
            boolean first = true;
            for (String s : values) {
                if (first) {
                    where = where.eq(field, (Object)s);
                    first = false;
                    continue;
                }
                where = where.or().eq(field, (Object)s);
            }
            return this.checkJsonData(where.query());
        }
        catch (Exception e) {
            GEL.e("Exception getting object by field with list: " + e.toString());
            return null;
        }
    }

    public <T> List<T> getObjectsBetweenDates(T t, String value, Calendar cStart, Calendar cEnd) {
        try {
            String sql = "SELECT * FROM " + GEReflectionUtils.getTableName(t.getClass()) + " WHERE " + value + " BETWEEN DATE('" + GEDateUtils.formatDate(cStart, DATE_FORMAT_ORMLITE) + "') AND DATE('" + GEDateUtils.formatDate(cEnd, DATE_FORMAT_ORMLITE) + "')";
            RuntimeExceptionDao dao = this.getDao(t);
            GenericRawResults rawResults = dao.queryRaw(sql, dao.getRawRowMapper(), new String[0]);
            return rawResults.getResults();
        }
        catch (Exception e) {
            GEL.e("Exception getting object between dates average: " + e.toString());
            return null;
        }
    }

    public boolean update(Object object) {
        try {
            this.updateJsonData(object);
            return this.getDao(object).update(object) > 0;
        }
        catch (Exception e) {
            GEL.e("Exception updating object: " + e.toString());
            return false;
        }
    }

    public boolean updateId(Object object, String newId) {
        try {
            return this.getDao(object).updateId(object, (Object)newId) > 0;
        }
        catch (Exception e) {
            GEL.e("Exception updating id of an object: " + e.toString());
            return false;
        }
    }

    public boolean delete(Object object) {
        try {
            return this.getDao(object).deleteById((Object)this.getId(object)) > 0;
        }
        catch (Exception e) {
            GEL.e("Exception deleting object by Id: " + e.toString());
            return false;
        }
    }

    public <T> int deleteObjectsByFields(T t, String fields) {
        try {
            DeleteBuilder deleteBuilder = this.getDao(t).deleteBuilder();
            this.whereByFields((StatementBuilder)deleteBuilder, t, fields);
            return deleteBuilder.delete();
        }
        catch (Exception e) {
            GEL.e("Exception deleting objects by fields: " + e.toString());
            return 0;
        }
    }

    public <T> int deleteObjectsByFields(Class<T> klass, String fields) {
        try {
            DeleteBuilder deleteBuilder = this.getDao(klass).deleteBuilder();
            this.whereByFields((StatementBuilder)deleteBuilder, null, fields);
            return deleteBuilder.delete();
        }
        catch (Exception e) {
            GEL.e("Exception deleting objects by fields: " + e.toString());
            return 0;
        }
    }

    public int deleteAll(Class c) {
        try {
            return this.getDao(c).deleteBuilder().delete();
        }
        catch (Exception e) {
            GEL.e("Exception deleting all objects: " + e.toString());
            return 0;
        }
    }

    public void deleteAllTables() {
        try {
            for (RuntimeExceptionDao dao : this.mDaos) {
                dao.deleteBuilder().delete();
            }
        }
        catch (Exception e) {
            GEL.e("Exception deleting all objects from all tables: " + e.toString());
        }
    }
}

