/*
 * Decompiled with CFR 0.152.
 */
package com.silicornio.geormlite.utils;

import android.util.Pair;
import com.silicornio.geormlite.general.GEL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class GEDateUtils {
    public static final String DATE_FORMAT_COMPLETE = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final long MS_SECOND = 1000L;
    public static final long MS_MINUTE = 60000L;
    public static final long MS_HOUR = 3600000L;
    public static final long MS_DAY = 86400000L;
    public static final long MS_WEEK = 604800000L;

    public static String formatDate(Calendar c, String format) {
        if (c == null) {
            c = Calendar.getInstance();
            c.setTimeInMillis(0L);
            c.set(1, 1990);
        }
        return GEDateUtils.formatDate(c.getTime(), format);
    }

    public static String formatDate(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        if (date == null) {
            date = new Date(0L);
        }
        return sdf.format(date);
    }

    public static Date formatDateString(String sDate, String format) {
        if (sDate == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(sDate);
        }
        catch (Exception e) {
            GEL.e("Exception reading date '" + sDate + "' with format '" + format + "': " + e.toString());
            return new Date(0L);
        }
    }

    public static Calendar generateCalendar(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(date.getTime());
        return c;
    }

    public static Calendar generateCalendar(Calendar cal) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(cal.getTimeInMillis());
        return c;
    }

    public static Date generateDate(Calendar cal) {
        return new Date(cal.getTimeInMillis());
    }

    public static Date generateDate(Date date) {
        return new Date(date.getTime());
    }

    public static List<Pair<Calendar, Calendar>> getRangeInMonths(Calendar cStart, Calendar cEnd) {
        ArrayList<Pair<Calendar, Calendar>> calendars = new ArrayList<Pair<Calendar, Calendar>>();
        Calendar cActual = GEDateUtils.generateCalendar(cStart);
        cActual.set(5, 1);
        while (cActual.compareTo(cEnd) < 0) {
            Calendar cF;
            Calendar c0 = calendars.size() == 0 ? GEDateUtils.generateCalendar(cStart) : GEDateUtils.generateCalendar(cActual);
            cActual.add(2, 1);
            if (cActual.after(cEnd)) {
                cF = GEDateUtils.generateCalendar(cEnd);
            } else {
                cF = GEDateUtils.generateCalendar(cActual);
                cF.add(6, -1);
            }
            calendars.add((Pair<Calendar, Calendar>)new Pair((Object)c0, (Object)cF));
        }
        return calendars;
    }

    public static int getNumDays(Calendar cIni, Calendar cEnd) {
        long difMillis = cEnd.getTimeInMillis() - cIni.getTimeInMillis();
        return (int)(difMillis / 86400000L);
    }

    public static Calendar getCalendar0() {
        Calendar c = Calendar.getInstance();
        c.setTime(GEDateUtils.formatDateString("0000-00-00 00:00:00.000", DATE_FORMAT_COMPLETE));
        return c;
    }

    public static Date getDate0() {
        return new Date(0L);
    }

    public static void cleanDay(Calendar c) {
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
    }

    public static void endOfDay(Calendar c) {
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
    }

    public static Calendar generateAdding1Day(Calendar c) {
        Calendar cal = GEDateUtils.generateCalendar(c);
        cal.add(6, 1);
        return cal;
    }

    public static Calendar generateAdding1Month(Calendar c) {
        Calendar cal = GEDateUtils.generateCalendar(c);
        cal.add(2, 1);
        return cal;
    }

    public static int getWeeksBetweenDates(Calendar cIni, Calendar cEnd) {
        return (int)((cEnd.getTimeInMillis() - cIni.getTimeInMillis()) / 604800000L) + 1;
    }

    public static void setLastDayMonth(Calendar c) {
        c.add(2, 1);
        c.add(6, -1);
    }

    public static Date copyYearMonthDay(Date dateOrigin, Date dateDestiny) {
        if (dateOrigin == null && dateDestiny == null) {
            return Calendar.getInstance().getTime();
        }
        if (dateOrigin == null) {
            return dateDestiny;
        }
        if (dateDestiny == null) {
            return dateOrigin;
        }
        Calendar calOrigin = Calendar.getInstance();
        calOrigin.setTime(dateOrigin);
        Calendar calDestiny = Calendar.getInstance();
        calDestiny.setTime(dateDestiny);
        return GEDateUtils.copyYearMonthDay(calOrigin, calDestiny).getTime();
    }

    public static Calendar copyYearMonthDay(Calendar cOrigin, Calendar cDestiny) {
        if (cOrigin == null && cDestiny == null) {
            return Calendar.getInstance();
        }
        if (cOrigin == null) {
            return cDestiny;
        }
        if (cDestiny == null) {
            return cOrigin;
        }
        cDestiny.set(1, cOrigin.get(1));
        cDestiny.set(2, cOrigin.get(2));
        cDestiny.set(5, cOrigin.get(5));
        return cDestiny;
    }

    public static Date copyHourMinute(Date dateOrigin, Date dateDestiny) {
        if (dateOrigin == null && dateDestiny == null) {
            return Calendar.getInstance().getTime();
        }
        if (dateOrigin == null) {
            return dateDestiny;
        }
        if (dateDestiny == null) {
            return dateOrigin;
        }
        Calendar calOrigin = Calendar.getInstance();
        calOrigin.setTime(dateOrigin);
        Calendar calDestiny = Calendar.getInstance();
        calDestiny.setTime(dateDestiny);
        return GEDateUtils.copyHourMinute(calOrigin, calDestiny).getTime();
    }

    public static Calendar copyHourMinute(Calendar cOrigin, Calendar cDestiny) {
        if (cOrigin == null && cDestiny == null) {
            return Calendar.getInstance();
        }
        if (cOrigin == null) {
            return cDestiny;
        }
        if (cDestiny == null) {
            return cOrigin;
        }
        cDestiny.set(11, cOrigin.get(11));
        cDestiny.set(12, cOrigin.get(12));
        return cDestiny;
    }
}

