/*
 * Decompiled with CFR 0.152.
 */
package com.silencedut.router.dispatcher;

import android.os.Looper;
import com.annotation.RunThread;
import com.silencedut.router.dispatcher.AsyncThreadDispatcher;
import com.silencedut.router.dispatcher.BackgroundDispatcher;
import com.silencedut.router.dispatcher.Dispatcher;
import com.silencedut.router.dispatcher.MainThreadDispatcher;
import com.silencedut.router.dispatcher.PostingThreadDispatcher;

public class DispatcherFactory {
    private static final Dispatcher MAIN_THREAD_DISPATCHER = new MainThreadDispatcher();
    private static final Dispatcher POSTING_THREAD_DISPATCHER = new PostingThreadDispatcher();
    private static final Dispatcher BACKGROUND_THREAD_DISPATCHER = new BackgroundDispatcher();
    private static volatile Dispatcher sAsyncThreadDispatcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Dispatcher getEventDispatch(RunThread runThread) {
        switch (runThread) {
            case MAIN: {
                return DispatcherFactory.isMainThread() ? POSTING_THREAD_DISPATCHER : MAIN_THREAD_DISPATCHER;
            }
            case POSTING: {
                return POSTING_THREAD_DISPATCHER;
            }
            case BACKGROUND: {
                return !DispatcherFactory.isMainThread() ? POSTING_THREAD_DISPATCHER : BACKGROUND_THREAD_DISPATCHER;
            }
            case ASYNC: {
                if (sAsyncThreadDispatcher != null) return sAsyncThreadDispatcher;
                Class<DispatcherFactory> clazz = DispatcherFactory.class;
                synchronized (DispatcherFactory.class) {
                    if (sAsyncThreadDispatcher != null) return sAsyncThreadDispatcher;
                    sAsyncThreadDispatcher = new AsyncThreadDispatcher();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return sAsyncThreadDispatcher;
                }
            }
        }
        return MAIN_THREAD_DISPATCHER;
    }

    private static boolean isMainThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }
}

