/*
 * Decompiled with CFR 0.152.
 */
package com.silencedut.router;

import com.silencedut.router.Reception;
import com.silencedut.router.Router;
import com.silencedut.router.RouterException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

class ReceiverHandler
implements InvocationHandler {
    private Router mRouter;
    private Class mReceiverType;
    private Set<WeakReference<Object>> mReceivers;
    private AtomicInteger sameTypeReceivesCount = new AtomicInteger(0);
    Object mReceiverProxy;

    ReceiverHandler(Router router, Class receiverType, Set<WeakReference<Object>> mReceivers) {
        this.mRouter = router;
        this.mReceiverType = receiverType;
        this.mReceivers = mReceivers;
        this.mReceiverProxy = Proxy.newProxyInstance(this.mReceiverType.getClassLoader(), new Class[]{this.mReceiverType}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        for (WeakReference<Object> weakReference : this.mReceivers) {
            Object receiver = weakReference.get();
            if (!this.mReceiverType.isInstance(receiver)) continue;
            if (!this.mRouter.mAnnotateMethodOnInterface) {
                try {
                    method = receiver.getClass().getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new RouterException(String.format("%s no method %s", receiver.getClass().getName(), method.getName()), e);
                }
            }
            Reception reception = new Reception(receiver, method, args);
            reception.dispatchEvent();
            this.mRouter.addDispatch(reception.mDispatcher);
        }
        return null;
    }

    int getSameTypeReceivesCount() {
        this.sameTypeReceivesCount.set(0);
        for (WeakReference<Object> weakReference : this.mReceivers) {
            Object receiver = weakReference.get();
            if (!this.mReceiverType.isInstance(receiver)) continue;
            this.sameTypeReceivesCount.incrementAndGet();
        }
        return this.sameTypeReceivesCount.get();
    }
}

