/*
 * Decompiled with CFR 0.152.
 */
package com.silencedut.router;

import com.silencedut.router.Annotation.RunThread;
import com.silencedut.router.Annotation.Subscribe;
import com.silencedut.router.RouterException;
import com.silencedut.router.dispatcher.Dispatcher;
import com.silencedut.router.dispatcher.DispatcherFactory;
import java.lang.reflect.Method;

class Reception {
    private Object mReceiver;
    private Method mInvokedMethod;
    private Object[] mArgs;
    private Runnable mRunnable;
    Dispatcher mDispatcher;

    Reception(Object receiver, Method invokedMethod, Object[] args) {
        this.mReceiver = receiver;
        this.mInvokedMethod = invokedMethod;
        this.mArgs = args;
        this.initReception();
    }

    private void initReception() {
        this.mInvokedMethod.setAccessible(true);
        this.mRunnable = this.produceEvent();
        RunThread runThread = RunThread.MAIN;
        Subscribe subscribeAnnotation = this.mInvokedMethod.getAnnotation(Subscribe.class);
        if (subscribeAnnotation != null) {
            runThread = subscribeAnnotation.runThread();
        }
        this.mDispatcher = DispatcherFactory.getEventDispatch(runThread);
    }

    void dispatchEvent() {
        this.mDispatcher.dispatch(this.mRunnable);
    }

    private Runnable produceEvent() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (Reception.this.mInvokedMethod != null && Reception.this.mReceiver != null) {
                        Reception.this.mInvokedMethod.invoke(Reception.this.mReceiver, Reception.this.mArgs);
                    }
                }
                catch (Exception e) {
                    throw new RouterException("UnHandler Exception when method invoke ," + e.getCause());
                }
            }
        };
    }
}

